﻿using System;
using System.Collections.ObjectModel;
using System.Drawing;
using System.IO;
using System.Text;


namespace WindowsFormsApplication1
{
    public class TData
    {
        public Collection<double[]> values = new Collection<double[]>();
        public int dataLength = 0;

        public void readData(string FileName)
        {
            foreach (var str in File.ReadLines(FileName, Encoding.Default))
            {
                int i;
                string[] strLine = str.Split(',');
                double[] line = new double[strLine.Length];
                for (i = 0; i < strLine.Length; i++)
                    line[i] = Convert.ToDouble(strLine[i]);
                dataLength = line.Length;
                values.Add(line);
            }
        }

        public void AddElement(Bitmap bmpSource, int iIndex)
        {
            int x, y;
            double[] line = new double[bmpSource.Height * bmpSource.Width];

            for (x = 0; x < bmpSource.Width; x++)
            {
                for (y = 0; y < bmpSource.Height; y++)
                {
                    Color pix = bmpSource.GetPixel(x, y);
                    line[x + y * bmpSource.Width] = pix.R;
                }
            }
            values.Add(line);
            dataLength = bmpSource.Height * bmpSource.Width;
            int newIndex = new int();
            newIndex = iIndex;
        }

        public void EmptyData()
        {
            values.Clear();
        }
    }
}

