﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.ComponentModel;

/*                  Backpropagation with the Iris data set                       */
/*                                                                               */
/*                       www.mosismath.com                                       */

namespace WindowsFormsApplication1
{
   
    public partial class Mainwin : Form
    {
        int samples = 0;
        int dataLength = 0;
        const int features = 4;
        int layers = 1;
  
        TData data = new TData();
        private NeuroNet net;
        BackgroundWorker calculationThread;

        public Mainwin()
        {
            int i,j;
            DataGridViewCell cell;

            InitializeComponent();
            data.readData(Application.StartupPath + "\\data.csv");
            samples = data.values.Count;

            net = new NeuroNet(features, samples);
            layers = net.layer.Count;
            gRise.ColumnCount = 4;
            gRise.RowCount = 10;
            samples = data.values.Count;
            dataLength = data.dataLength;
            dgDataView.RowCount = samples;
            dgDataView.ColumnCount = 10;

            dgDataView.Columns[0].HeaderText = "x1";
            dgDataView.Columns[1].HeaderText = "x2";
            dgDataView.Columns[2].HeaderText = "x3";
            dgDataView.Columns[3].HeaderText = "x4";
            dgDataView.Columns[4].HeaderText = "y";
            dgDataView.Columns[5].HeaderText = "out 1";
            dgDataView.Columns[6].HeaderText = "out 2";

            for (i = 0; i < samples; i++)
            {
                dgDataView.Rows[i].HeaderCell.Value = (i + 1).ToString();
                for (j = 0; j <= features; j++)
                {
                    cell = dgDataView[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i)[j], 4).ToString();
                }
            }

            calculationThread = new BackgroundWorker();
            calculationThread.DoWork += calculate;
            calculationThread.RunWorkerCompleted += calculationCompleted;
        }

        
        private void calculate(object sender, System.ComponentModel.DoWorkEventArgs e)
        {
            net.TrainNet(data);
        }

        void calculationCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            int i, j, k;
            double[] res;
            double[] tempX = new double[features];
            DataGridViewCell cell;
            TLayer actLayer = net.layer.ElementAt(0);
            tbCost.Text = Math.Round(net.cost, 8).ToString();

            // print data
            for (i = 0; i < samples; i++)
            {
                for (k = 0; k < features; k++)
                {
                    tempX[k] = data.values.ElementAt(i)[k];
                }
                res = net.ForwardProp(tempX);
                cell = dgDataView[5, i];
                cell.Value = Math.Round(res[0], 4).ToString();
                cell = dgDataView[6, i];
                cell.Value = Math.Round(res[1], 4).ToString();
            }

            actLayer = net.layer.ElementAt(0);
            int rowCount = 0;
            for (i = 0; i < layers; i++)
            {
                actLayer = net.layer.ElementAt(i);
                for (j = 0; j < actLayer.featuresIn; j++)
                {
                    for (k = 0; k < actLayer.featuresOut; k++)
                    {
                        cell = gRise[k, rowCount + j];
                        cell.Value = Math.Round(actLayer.w[j, k], 6).ToString();
                    }
                    if (j < actLayer.offs.Length)
                    {
                        cell = gRise[k + 1, rowCount + j];
                        cell.Value = Math.Round(actLayer.offs[j], 6).ToString();
                    }
                }
                rowCount = rowCount + actLayer.featuresIn + 1;
            }
            net.WriteTrainedData(Application.StartupPath);
            Cursor.Current = Cursors.Default;
            this.Cursor = Cursors.Default;
            dgDataView.Cursor = Cursors.Default;
            gRise.Cursor = Cursors.Default;
            bt_Calc.Enabled = true;
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            Cursor.Current = Cursors.WaitCursor;
            bt_Calc.Enabled = false;
            calculationThread.RunWorkerAsync();

        }
    }
}
