﻿
using System.Collections.Generic;
using System.Linq;

namespace WindowsFormsApplication1
{
    class NeuroNet
    {
        const int iterations = 100000;

        public List<TLayer> layer = new List<TLayer>();
        readonly int features;
        int layers = 1;
        public double cost = 1000;
        double costSum = 0;
        public int samples = 0;

        public NeuroNet(int IFeatures, int ISamples)
        {
            features = IFeatures;
            samples = ISamples;
            TLayer tempLayer;
            tempLayer = new TLayer(4, 2, 0.1);
            layer.Add(tempLayer);
            tempLayer = new TLayer(2, 2, 0.4);
            layer.Add(tempLayer);
            layers = layer.Count;
        }


        public double[] ForwardProp(double[] x)
        {
            int i, j, k;
            TLayer actLayer = layer.ElementAt(0);
            double[] actX = new double[x.Length];
            for (i = 0; i < x.Length; i++)
                actX[i] = x[i];

            for (i = 0; i < layers; i++)
            {
                for (j = 0; j < actLayer.featuresOut; j++)
                {
                    actLayer.x[j] = actLayer.offs[j];
                    for (k = 0; k < actLayer.featuresIn; k++)
                    {
                        actLayer.x[j] = actLayer.x[j] + actX[k] * actLayer.w[k, j];
                    }
                    actLayer.o[j] = actLayer.Act(actLayer.x[j]);
                }

                for (j = 0; j < actLayer.x.Length; j++)
                    actX[j] = actLayer.o[j];

                if (i < layers - 1)
                    actLayer = layer.ElementAt(i + 1);
            }
            return actLayer.o;
        }


        private void BackwardProp(double[] x, double[] y)
        {
            int i, j, k;
            if (layers > 1)
            {
                TLayer actLayer = layer.ElementAt(layers - 2);   // actual computed layer
                TLayer layerRight = layer.ElementAt(layers - 1); // next layer to the right of the actual one
                double[] actX = new double[x.Length];

                for (j = 0; j < actLayer.x.Length; j++)
                    actX[j] = actLayer.o[j];
                actLayer =layer.ElementAt(layers - 1);
                //last layer
                for (j = 0; j < actLayer.featuresOut; j++)
                {
                    costSum = costSum + ((y[j] - actLayer.o[j]) * (y[j] - actLayer.o[j]));
                    // actLayer.gradient[j] = -(y[j] - actLayer.o[j]) * actLayer.dAct(actLayer.o[j]);
                    actLayer.gradient[j] = -(y[j] - actLayer.o[j]);
                }

                for (j = 0; j < actLayer.featuresIn; j++)
                {
                    for (k = 0; k < actLayer.featuresOut; k++)
                        actLayer.deltaW[j, k] = actLayer.deltaW[j, k] + actLayer.gradient[k] * actX[j];
                }

                for (j = 0; j < actLayer.featuresOut; j++)
                {
                    actLayer.deltaOffs[j] = actLayer.deltaOffs[j] + actLayer.gradient[j];
                }

                // all layers except the last one

                for (i = layers - 2; i >= 0; i--)
                {
                    actLayer = layer.ElementAt(i);
                    layerRight = layer.ElementAt(i + 1);
                    if (i > 0)
                    {
                        TLayer layerLeft = layer.ElementAt(i - 1);
                        for (j = 0; j < layerLeft.o.Length; j++)
                            actX[j] = layerLeft.o[j];
                    }
                    else
                    {
                        for (j = 0; j < x.Length; j++)
                            actX[j] = x[j];
                    }
                    for (j = 0; j < actLayer.featuresOut; j++)
                    {
                        actLayer.gradient[j] = 0;
                        for (k = 0; k < layerRight.featuresOut; k++)
                            actLayer.gradient[j] = actLayer.gradient[j] + (layerRight.gradient[k] * actLayer.dAct(actLayer.o[j]) * layerRight.w[j, k]);
                        actLayer.deltaOffs[j] = actLayer.deltaOffs[j] + actLayer.gradient[j];
                        for (k = 0; k < actLayer.featuresIn; k++)
                            actLayer.deltaW[k, j] = actLayer.deltaW[k, j] + actLayer.gradient[j] * actX[k];
                    }
                }
            }
        }


        private void UpdateValues()
        {
            int i, k, l;
            TLayer actLayer = layer.ElementAt(layers - 1);

            for (i = 0; i < layers; i++)
            {
                actLayer = layer.ElementAt(i);
                for (k = 0; k < actLayer.featuresOut; k++)
                {
                    for (l = 0; l < actLayer.featuresIn; l++)
                    {
                        actLayer.w[l, k] = actLayer.w[l, k] - actLayer.deltaW[l, k] / samples * actLayer.learning_rate;
                    }
                    actLayer.offs[k] = actLayer.offs[k] - actLayer.deltaOffs[k] / samples * actLayer.learning_rate;
                }
            }
        }



        private double[] PrepareOutput(int iIndex, int iOrder)
        {
            int i;
            double[] tempY = new double[iOrder];
  
            if (iIndex == 1)
            {
                tempY[0] = 0;
                tempY[1] = 0;
            }
            else
            {
                if (iIndex == 2)
                {
                    tempY[0] = 1;
                    tempY[1] = 0;
                }
                else
                {
                    tempY[0] = 1;
                    tempY[1] = 1;
                }
            }
            return tempY;
        }

        public void TrainNet(TData data)
        {
            int i, j, k;
            int count = 0;
            double[] tempX = new double[features];
            double[] tempY = new double[2];
            int actY;
            TLayer actLayer = layer.ElementAt(0);

            while (count < iterations)
            {
                actLayer = layer.ElementAt(0);

                for (i = 0; i < layers; i++)
                {
                    actLayer = layer.ElementAt(i);
                    for (j = 0; j < actLayer.featuresOut; j++)
                    {
                        actLayer.gradient[j] = 0;
                        actLayer.deltaOffs[j] = 0;
                        for (k = 0; k < actLayer.featuresIn; k++)
                        {
                            actLayer.deltaW[k, j] = 0;
                        }
                    }
                }
                count++;

                costSum = 0;
                for (i = 0; i < samples; i++)
                {
                    for (k = 0; k < features; k++)
                    {
                        tempX[k] = data.values.ElementAt(i)[k];
                    }
                    actY = (int)data.values.ElementAt(i)[k];
                    ForwardProp(tempX);
                    BackwardProp(tempX, PrepareOutput(actY, actLayer.featuresOut));
                }
                UpdateValues();
                cost = costSum / samples;
            }
        }

        public double CheckCost(TData data)
        {
            int i, j, k;
            int count = 0;
            double[] tempX = new double[features];
            double[] tempY = new double[3];
            int actY;
            TLayer actLayer = layer.ElementAt(0);

            actLayer = layer.ElementAt(0);

            for (i = 0; i < layers; i++)
            {
                actLayer = layer.ElementAt(i);
                for (j = 0; j < actLayer.featuresOut; j++)
                {
                    actLayer.gradient[j] = 0;
                    actLayer.deltaOffs[j] = 0;
                    for (k = 0; k < actLayer.featuresIn; k++)
                    {
                        actLayer.deltaW[k, j] = 0;
                    }
                }
            }
            count++;

            costSum = 0;
            for (i = 0; i < samples; i++)
            {
               
                for (k = 0; k < features; k++)
                {
                    tempX[k] = data.values.ElementAt(i)[k];
                }
                actY = (int)data.values.ElementAt(i)[k];
                tempY = PrepareOutput(actY, actLayer.featuresOut);
                ForwardProp(tempX);
                actLayer = layer.ElementAt(layers - 1);
                for (j = 0; j < actLayer.featuresOut; j++)
                {
                    costSum = costSum + ((tempY[j] - actLayer.o[j]) * (tempY[j] - actLayer.o[j]));
                }
            }
            //UpdateValues();
            cost = costSum / samples;
            return cost;
        }

        public void WriteTrainedData(string DataPath)
        {
            int i;
            for (i = 0; i < layers; i++)
            {
                layer.ElementAt(i).WriteTrainedData(DataPath + "\\Layer" + i.ToString() + ".json");
            }
        }

        public void ReadTrainedData(string DataPath)
        {
            int i;
            for (i = 0; i < layers; i++)
            {
                layer.ElementAt(i).ReadTrainedData(DataPath + "\\Layer" + i.ToString() + ".json");
            }
        }
    }
}
