﻿
using System;
using System.IO;
using System.Runtime.Serialization;
using System.Runtime.Serialization.Json;
using System.Text;

namespace WindowsFormsApplication1
{
    public delegate double function(double value);

    [Serializable]
    public class TWeightRow
    {
        [DataMember]
        public double[] w;
    }

    [Serializable]
    public class TOffset
    {
        [DataMember]
        public double[] offs;
    }

    [Serializable]
    public class ParameterTable
    {
        [DataMember]
        public TWeightRow[] weightRow;

        [DataMember]
        public TOffset offs;
    }

    class TLayer
    {
        public int featuresIn;
        public int featuresOut;
        public double learning_rate;
        public double[] x;
        public double[] o;
        public double[,] w;
        public double[] offs;
        public double[] deltaOffs;
        public double[] gradient;
        public double[,] deltaW;
      
        public function Act;
        public function dAct;

        public TLayer(int iFeaturesIn, int iFeaturesOut, double dLearning_rate)
        {
            int i, j, k;
            featuresIn = iFeaturesIn;
            featuresOut = iFeaturesOut;
            learning_rate = dLearning_rate;
            w = new double[featuresIn, featuresOut];
            o = new double[featuresOut];
            offs = new double[featuresOut];
            deltaOffs = new double[featuresOut];
            deltaW = new double[featuresIn, featuresOut];
            x = new double[featuresOut];
            gradient = new double[featuresOut];
            for (j = 0; j < featuresOut; j++)
            {
                offs[j] = 0;
                deltaOffs[j] = 0;
                for (k = 0; k < featuresIn; k++)
                {
                    w[k, j] = 0.5;
                    deltaW[k, j] = 0;
                }
            }
            Act = Sigmoid;
            dAct = dSigmoid;

            //Act = TanH;
            //dAct = dTanH;
        }

        public double Sigmoid(double x)
        {
            return 1.0 / (1.0 + Math.Exp(- 0.5 * x));
        }

        public double dSigmoid(double x)
        {
            return  0.5 * x * (1 - x);
        }

        public double TanH(double x)
        {
            return Math.Tanh(x) / 2.0 + 0.5;
        }

        public double dTanH(double x)
        {
            return 1.0 - x * x + x - 1.0;
        }

        public double Relu(double x)
        {
            if (x > 0.0)
                return x;
            else
                return 0.001 * x;
        }

        public double dRelu(double x)
        {
            if (x > 0.0)
                return 1.0;
            else
                return 0.001;
        }

        public double Neutral(double x)
        {
            return x;
        }

        public double dNeutral(double x)
        {
            return 1;
        }

        // Export to Json without Newtonsoft library :-)
        public void WriteTrainedData(string FileName)
        {
            int i, j;
            MemoryStream ms = new MemoryStream();
            byte[] startBytes = Encoding.ASCII.GetBytes("{\n \"weightRow\": [");
            byte[] eol = System.Text.Encoding.ASCII.GetBytes(",\n");
            ms.Write(startBytes, 0, startBytes.Length);
            DataContractJsonSerializer ser = new DataContractJsonSerializer(typeof(TWeightRow));
            for (i = 0; i < featuresIn; i++)
            {
                TWeightRow tempW = new TWeightRow();
                tempW.w = new double[featuresOut];
                for (j = 0; j < featuresOut; j++)
                {
                    tempW.w[j] = w[i, j];
                }
                ser.WriteObject(ms, tempW);
                if (i < featuresIn - 1)
                    ms.Write(eol, 0, eol.Length);
            }

            byte[] endBytes = Encoding.ASCII.GetBytes("],\n  \"offs\": {");
            ms.Write(endBytes, 0, endBytes.Length);

            DataContractJsonSerializer offset = new DataContractJsonSerializer(typeof(TOffset));
            TOffset tempO = new TOffset();
            tempO.offs = new double[featuresOut];
            for (j = 0; j < featuresOut; j++)
            {
                tempO.offs[j] = offs[j];
            }
            offset.WriteObject(ms, tempO);
            ms.Write(eol, 0, eol.Length);

            endBytes = Encoding.ASCII.GetBytes("}");
            ms.Write(endBytes, 0, endBytes.Length);

            using (FileStream fs = new FileStream(FileName, FileMode.Create))
            {
                ms.Position = 0;
                fs.Write(ms.ToArray(), 0, ms.ToArray().Length);
                ms.Close();
                fs.Close();
            }
        }

        public void ReadTrainedData(string FileName)
        {
            int i, j;

            using (StreamReader r = new StreamReader(FileName))
            {
                string response = r.ReadToEnd();
                ParameterTable table = new ParameterTable();
                MemoryStream m = new MemoryStream(Encoding.UTF8.GetBytes(response));
                DataContractJsonSerializer ser = new DataContractJsonSerializer(table.GetType());
                table = ser.ReadObject(m) as ParameterTable;
                for (i = 0; i < table.weightRow.Length; i++)
                {
                    for (j = 0; j < featuresOut; j++)
                    {
                        w[i, j] = table.weightRow[i].w[j];
                    }
                }
                for (j = 0; j < featuresOut; j++)
                {
                    offs[j] = table.offs.offs[j];
                }
            }
        }
    }
}
