﻿using System;
using System.Linq;
using System.Windows.Forms;

/*                Backpropagation  Test for Iris data                            */
/*                                                                               */
/*                       www.mosismath.com                                       */

namespace WindowsFormsApplication1
{
   
    public partial class Mainwin : Form
    {

        int samples = 0;
        int dataLength = 0;
        const int features = 4;
        private TData data = new TData();
        private NeuroNet net;

        public Mainwin()
        {
            int i,j;
            DataGridViewCell cell;


            InitializeComponent();
            data.readData(Application.StartupPath + "\\Data_iris_test.csv");
			samples = data.values.Count;

            net = new NeuroNet(features, samples);
            net.ReadTrainedData(Application.StartupPath);
			

            dataLength = data.dataLength;
            dgDataView.RowCount = samples;
            dgDataView.ColumnCount = 10;

            dgDataView.Columns[0].HeaderText = "x1";
            dgDataView.Columns[1].HeaderText = "x2";
            dgDataView.Columns[2].HeaderText = "x3";
            dgDataView.Columns[3].HeaderText = "x4";
            dgDataView.Columns[4].HeaderText = "y";
            dgDataView.Columns[5].HeaderText = "Res";
            dgDataView.Columns[6].HeaderText = "[%]";
            for (i = 0; i < samples; i++)
            {
                dgDataView.Rows[i].HeaderCell.Value = (i + 1).ToString();
                for (j = 0; j <= features; j++)
                {
                    cell = dgDataView[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i)[j], 4).ToString();
                }
            }
        }

      
        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i, k;
            double[] res;
            double[] tempX = new double[features];
            DataGridViewCell cell;
            TLayer actLayer = net.layer.ElementAt(0);
           
            // print data
            for (i = 0; i < samples; i++)
            {
                for (k = 0; k < features; k++)
                {
                    tempX[k] = data.values.ElementAt(i)[k];
                }
                res = net.ForwardProp(tempX);
                cell = dgDataView[5, i];
                if ((res[0] < 0.5) && (res[1] < 0.5))
                {
                    cell.Value = "Iris_setosa";
                }
                else
                {
                    if (res[1] < 0.5)
                    {
                        cell.Value = "Iris-versicolor";
                    }
                    else
                    {
                        cell.Value = "Iris_virginica";
                    }
                }
                double tempRes = 0;
                if (res[0] < 0.5)
                    tempRes = tempRes + (1 - res[0]) * (1 - res[0]);
                else
                    tempRes = tempRes + res[0] * res[0];
                if (res[1] < 0.5)
                    tempRes = tempRes + (1 - res[1]) * (1 - res[1]);
                else
                    tempRes = tempRes + res[1] * res[1];
                cell = dgDataView[6, i];
                cell.Value = Math.Round(Math.Sqrt(tempRes/2) * 100, 4).ToString();
            }
        }
    }
}
