﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.Collections.ObjectModel;

/* Multy variable linear regression using Gradient Descend  */ 
/*                  www.mosismath.com                       */

namespace WindowsFormsApplication1
{
    

    public partial class Mainwin : Form
    {

        int samples = 60;
        const int iterations = 5000;
        const int features = 3;
        double learning_rate = 0.01;
        double cost = 1000;
        double[] cost_history = new double[iterations];
        double[] rise = new double[features];
        double offset = 0;
        Data data = new Data();


        double cost_function(Collection<double[]> values, double[] rise)
        {
            int i, j;
            double cost = 0;
            double[] predictions = update_values(values, rise);
            double[] x;
            double y;

            cost = 0;
            for (j = 0; j < samples; j++)
            {
                x = values[j];
                y = x[features];
                cost += (y - predictions[j]) * (y - predictions[j]);
            }
            
            cost = cost / samples / 2.0;
            return cost;
        }


        double[] update_values(Collection<double[]> values, double[] rise)
        {
            double[] predictions = new double[samples];
            double[] x;
            for (int i = 0; i < samples; i++)
            {
                predictions[i] = 0;
                x = values[i];
                for (int j = 0; j < features; j++)
                {
                    predictions[i] = predictions[i] + x[j] * rise[j];
                }
                predictions[i] = predictions[i] + offset;
            }
            return predictions;
        }


        double[] update_rise(Collection<double[]> values, double[] rise, double learning_rate)
        {
            int i, j;
            double[] predictions = update_values(values, rise);
            double[] d_rise = new double[features];
            double[] x;
            double y;
            double tempSum = 0;

            for (i = 0; i < features; i++)
            {
                d_rise[i] = 0;
                tempSum = 0;
                for (j = 0; j < samples; j++)
                {
                    x = values.ElementAt(j);
                    y = x[features];
                    tempSum = tempSum + x[i] * (y - predictions[j]);
                    if(Math.Abs(tempSum) > 1e6)
                    {
                        d_rise[i] = d_rise[i] - tempSum / samples;
                        tempSum = 0;
                    }
                }
                d_rise[i] = d_rise[i] - tempSum / samples;
            }

            for (i = 0; i < features; i++)
            {
                rise[i] = rise[i] - learning_rate * d_rise[i];
            }
            return rise;
        }


        double[] find_min(Collection<double[]> values, double[] rise, double learning_rate, int maxIers)
        {
            int count = 0;
            double oldCost = -1;
            double divCost = oldCost - cost;
            double[] ret = new double[2];

            while (Math.Abs(divCost) > 1e-6 && count < maxIers)
            {
                rise = update_rise(values, rise, learning_rate);
                cost = cost_function(values, rise);
                divCost = oldCost - cost;
                oldCost = cost;
                count++;
                if (divCost < -0.1)
                {
                    learning_rate = -learning_rate / 2;
                }
            }

            return rise;
        }


        double mean_function(Collection<double[]> values, double[] rise)
        {
            int i, j;
            double mean = 0;
            double[] predictions = update_values(values, rise);
            double y;

            for (j = 0; j < samples; j++)
            {
                y = values.ElementAt(j)[features];
                mean += (y - predictions[j]);
            }
            mean = mean / samples / 2;
            return mean;
        }


        public Mainwin()
        {
            int i, j;
            DataGridViewCell cell;

            InitializeComponent();
            data.readData(Application.StartupPath + "\\data.csv");
            gResult.ColumnCount = features + 1;
            gResult.RowCount = 1;
            samples = data.values.Count;

            dgData.RowCount = samples;
            dgData.ColumnCount = features + 3;
            for (j = 0; j < features; j++)
                dgData.Columns[j].HeaderText = "x" + (j+1).ToString();
            dgData.Columns[j].HeaderText = "y";
            dgData.Columns[j+1].HeaderText = "f(x)";
            dgData.Columns[j + 2].HeaderText = "dev [%]";
            for (i = 0; i < samples; i++)
            {
                dgData.Rows[i].HeaderCell.Value = (i+1).ToString();
    
                for (j = 0; j <= features; j++)
                {
                    cell = dgData[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i)[j], 4).ToString();
                }
            }
        }


        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i, j;
            int count = 0;
            double oldCost = 1e60;
            double divCost = 10;
            double lastCost = 10;
            double step = 0.5;
            double x, y;
            DataGridViewCell cell;

            offset = 0;

            while ((Math.Abs(divCost) > 0.000001) && (count < 1000))
            {
                rise = find_min(data.values, rise, learning_rate, iterations);

                divCost = oldCost - cost;
                if (divCost < -0.001)
                {
                    step = -step / 2.0;
                }
                lastCost = oldCost;
                oldCost = cost;
                cost_history[count] = cost;
                offset = offset + mean_function(data.values, rise); 
                count++;
            }

            for (i = 0; i < features; i++)
            {
                gResult.Columns[i].HeaderText = "r" + (i + 1).ToString();
                cell = gResult[i, 0];
                cell.Value = Math.Round(rise[i], 4).ToString();
            }
            gResult.Columns[i].HeaderText = "offset";
            cell = gResult[i, 0];
            cell.Value = Math.Round(offset, 4).ToString();
            tbCost.Text = Math.Round(cost, 8).ToString();

            for (i = 0; i < samples; i++)
            {
                y = 0;
                for (j = 0; j < features; j++)
                {
                    x = data.values.ElementAt(i)[j];
                    y = y + x * rise[j];
                }
                y = y + offset;
                cell = dgData[features + 1, i];
                cell.Value = Math.Round(y, 4).ToString();
                if (data.values.ElementAt(i)[j] != 0)
                {
                    cell = dgData[features + 2, i];
                    cell.Value = Math.Round((y - data.values.ElementAt(i)[j]) / data.values.ElementAt(i)[j] * 100, 4).ToString();

                }
            }
        }
    }
}
