﻿using System;
using System.ComponentModel;
using System.Linq;
using System.Windows.Forms;
using System.Diagnostics;
using System.Collections.ObjectModel;

/*    Logistic Regression on Iris data set   */
/*          www.mosismath.com                */


namespace WindowsFormsApplication1
{
   
    public partial class Mainwin : Form
    {

        int samples = 60;
        const int maxIterations = 10000;
        const int features_in = 4;
        const int features_out = 2 * features_in;
        double learning_rate = 0.002;
        double cost = 1000;
        double[] rise = new double[features_out];
        double offset = 0;
        bool accuracy = false;
        Data data = new Data();
        Stopwatch timer = new Stopwatch();
        BackgroundWorker calculationThread;

        double cost_function(Collection<double[]> values, double[] rise)
        {
            int j;
            double cost = 0;
            double[] predictions = update_values(values, rise);
            double[] x;
            double y;

            cost = 0;
            for (j = 0; j < samples; j++)
            {
                x = values[j];
                y = x[features_in];
                cost += (y - predictions[j]) * (y - predictions[j]);
            }
            
            cost = cost / samples / 2.0;
            return cost;
        }


        double[] update_values(Collection<double[]> values, double[] rise)
        {
            double[] predictions = new double[samples];
            double[] x;
            for (int i = 0; i < samples; i++)
            {
                predictions[i] = 0;
                x = values[i];
                predictions[i] = 1/(1 + 1 / Math.Exp(F_x(x, rise, offset)));
            }
            return predictions;
        }

        double F_x(double[] x, double[] rise, double offs)
        {
            int i;
            double res = offs;
            for (i = 0; i < features_out / 2; i++)
            {
                res = res + x[i] * x[i] * rise[2 * i] + x[i] * rise[2 * i + 1];
            }
            return res;
        }

        double[] update_rise(Collection<double[]> values, double[] rise, double learning_rate)
        {
            int i, j;
            double[] d_rise = new double[features_out];
            double[] x;
            double y;
            double e;
            double[] tempSum = new double[2];
            double tempValue;

            for (i = 0; i < features_in; i++)
            {
                d_rise[2 * i] = 0;
                d_rise[2 * i + 1] = 0;
                tempSum[0] = 0;
                tempSum[1] = 0;
                for (j = 0; j < samples; j++)
                {
                    x = values.ElementAt(j);
                    y = x[features_in];
                  
                    e = Math.Exp(F_x(x, rise, offset));
                    tempValue = 2.0 * x[i] * e / (1.0 + e) / (1.0 + e) * (y - 1.0 / (1.0 + 1 / e));
                    tempSum[0] = tempSum[0] - x[i] * tempValue;
                    tempSum[1] = tempSum[1] - tempValue;
                    if (Math.Abs(tempSum[0]) > 1e6)
                    {
                        d_rise[2*i] = d_rise[2*i] + tempSum[0] / samples;
                        tempSum[0] = 0;
                    }
                    if (Math.Abs(tempSum[1]) > 1e6)
                    {
                        d_rise[2*i+1] = d_rise[2*i+1] + tempSum[1] / samples;
                        tempSum[1] = 0;
                    }
                }
                d_rise[2 * i] = d_rise[2 * i] + tempSum[0] / samples;
                d_rise[2 * i+1] = d_rise[2 * i+1] + tempSum[1] / samples;
            }

            for (i = 0; i < features_out; i++)
            {
                rise[i] = rise[i] - learning_rate * d_rise[i];
            }
            return rise;
        }

       
        double[] find_min(Collection<double[]> values, double[] rise, double learning_rate, int maxIters)
        {
            int count = 0;
            double oldCost = 100000;
            double divCost = oldCost - cost;
            double[] ret = new double[2];

            while (Math.Abs(divCost) > 1.0e-6 && count < maxIters)
            {
                rise = update_rise(values, rise, learning_rate);
                cost = cost_function(values, rise);
                divCost = oldCost - cost;
                oldCost = cost;
                count++;
            }
            return rise;
        }


        private void calculate(object sender, System.ComponentModel.DoWorkEventArgs e)
        {
            int i;
            int maxLoops = 10000;
            int count = 0;
            double oldCost = 1e60;
            double divCost = 10;
            double lastCost = 10;
            double step = -0.5;
                       
            for (i = 0; i < rise.Length; i++)
                rise[i] = 0.01;

            offset = 0;
            timer.Start();
            while ((Math.Abs(divCost) > 1.0e-8) && (count < maxLoops))
            {
                rise = find_min(data.values, rise, learning_rate, maxIterations);

                divCost = oldCost - cost;
                if (divCost < -1.0e-5)
                {
                    step = -step / 2.0;
                }
                lastCost = oldCost;
                oldCost = cost;
                offset = offset - step;
                count++;
            }
            accuracy = (count >= maxLoops);
            
        }


        void calculationCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            int i;
            double[] x;
            double y;
            DataGridViewCell cell;
            
            for (i = 0; i < features_out; i++)
            {
                gResult.Columns[i].HeaderText = "r" + (i + 1).ToString();
                cell = gResult[i, 0];
                cell.Value = Math.Round(rise[i], 4).ToString();
            }
            gResult.Columns[i].HeaderText = "offset";
            cell = gResult[i, 0];
            cell.Value = Math.Round(offset, 4).ToString();
            tbCost.Text = Math.Round(cost, 8).ToString();

            for (i = 0; i < samples; i++)
            {
                x = data.values.ElementAt(i);
                y = 1.0 / (1.0 + 1 / Math.Exp(F_x(x, rise, offset)));
                cell = dgData[4 + 1, i];
                cell.Value = Math.Round(y, 4).ToString();
            }
            Cursor.Current = Cursors.Default;
            this.Cursor = Cursors.Default;
            bt_Calc.Enabled = true;
            if (accuracy)
                MessageBox.Show("Maxh iterations reached","Accuracy");
        }

        public Mainwin()
        {
            int i, j;
            DataGridViewCell cell;

            InitializeComponent();

            data.readData(Application.StartupPath + "\\Data_Iris-versicolor.csv");
            //data.readData(Application.StartupPath + "\\Data_Iris_setosa.csv");
            //data.readData(Application.StartupPath + "\\Data_Iris_virginica.csv");

            gResult.ColumnCount = features_out + 1;
            gResult.RowCount = 1;
            samples = data.values.Count;

            dgData.RowCount = samples;
            dgData.ColumnCount = features_in + 2;
            for (j = 0; j < features_in; j++)
                dgData.Columns[j].HeaderText = "x" + (j+1).ToString();
            dgData.Columns[j].HeaderText = "y";
            dgData.Columns[j+1].HeaderText = "f(x)";
            for (i = 0; i < samples; i++)
            {
                dgData.Rows[i].HeaderCell.Value = (i+1).ToString();
    
                for (j = 0; j <= features_in; j++)
                {
                    cell = dgData[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i)[j], features_in).ToString();
                }
            }
            calculationThread = new BackgroundWorker();
            calculationThread.DoWork += calculate;
            calculationThread.RunWorkerCompleted += calculationCompleted;
        }


        private void bt_Calc_Click(object sender, EventArgs e)
        {
            this.Cursor = Cursors.WaitCursor;
            Cursor.Current = Cursors.WaitCursor;
            bt_Calc.Enabled = false;
            calculationThread.RunWorkerAsync();
        }
    }
}
