﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.Collections.ObjectModel;

/* Test application for Logistic Regression on Iris data set */
/*                  www.mosismath.com                        */

namespace WindowsFormsApplication1
{
    
    public partial class Mainwin : Form
    {

        int samples = 60;
        const int features_in = 4;
        const int features_out = 2 * features_in;    
      
        public Collection<double[]> rise = new Collection<double[]>();
        double[] offset = new double[3];
        Data data = new Data();
       
      
        double calc_probability(double[] x, double[] rise, double offset)
        {
            return 1 / (1 + 1 / Math.Exp(F_x(x, rise, offset)));
        }

        double F_x(double[] x, double[] rise, double offs)
        {
            int i;
            double res = offs;
            for (i = 0; i < features_out / 2; i++)
            {
                res = res + x[i] * x[i] * rise[2 * i] + x[i] * rise[2 * i + 1];
            }
            return res;
        }

        public Mainwin()
        {
            int i, j;
            DataGridViewCell cell;

            InitializeComponent();
            data.readData(Application.StartupPath + "\\Data_iris_test.csv");
            samples = data.values.Count;

            dgData.RowCount = samples;
            dgData.ColumnCount = features_in + 3;
            for (j = 0; j < features_in; j++)
                dgData.Columns[j].HeaderText = "x" + (j+1).ToString();
            dgData.Columns[j].HeaderText = "Id";
            dgData.Columns[j+1].HeaderText = "Flower";
            dgData.Columns[j + 2].HeaderText = "prob. [%]";
            for (i = 0; i < samples; i++)
            {
                dgData.Rows[i].HeaderCell.Value = (i+1).ToString();
    
                for (j = 0; j <= 4; j++)
                {
                    cell = dgData[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i)[j], 4).ToString();
                }
            }
            double[] line = new double[features_out];
            line[0] = -0.266911117385166; // Iris-versicolor
            line[1] = 4.44647285174394;
            line[2] = -0.398006207981798;
            line[3] = 1.99230425353624;
            line[4] = -0.86886832012433;
            line[5] = 6.38041608821672;
            line[6] = -1.80684858683798;
            line[7] = 2.08336743976039;
            rise.Add(line);
            offset[0] = -28.3515625;  // cost = 0.01658061

            line = new double[features_out];
            line[0] = -0.286108187010971; // Iris_setosa
            line[1] = -0.0211312424337379;
            line[2] = 0.156947996911337;
            line[3] = 0.0328673608705838;
            line[4] = -0.511702551274462;
            line[5] = -0.0874325706849323;
            line[6] = -0.0492368916735195;
            line[7] = -0.0295162745341735;
            rise.Add(line);
            offset[1] = 10.5;  // cost = 0.0004632837

            line = new double[features_out];
            line[0] = -0.133130761398118; // Iris_virginica
            line[1] = -0.190635611691179;
            line[2] = -0.208232166431125;
            line[3] = -0.113114389703814;
            line[4] = 0.663819392648918;
            line[5] = -0.0614590473586163;
            line[6] = 0.398233143708536;
            line[7] = 0.0786783945822739;
            rise.Add(line);
            offset[2] = -8.375;  // cost = 0.0116383088
        }



        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i;
            double[] x;
            double probability = 0;
            string flowerName = "";
            DataGridViewCell cell;


            for (i = 0; i < samples; i++)
            {
                x = data.values.ElementAt(i);
                probability = calc_probability(x, rise.ElementAt(0), offset[0]);
                if (probability > 0.5)
                {
                    flowerName = "Iris-versicolor";
                }
                else
                {
                    probability = calc_probability(x, rise.ElementAt(1), offset[1]);
                    if (probability > 0.5)
                    {
                        flowerName = "Iris_setosa";
                    }
                    else
                    {
                        probability = calc_probability(x, rise.ElementAt(2), offset[2]);
                        if (probability > 0.5)
                        {
                            flowerName = "Iris_virginica";
                        }
                        else
                        {
                            flowerName = "Not recognized";
                        }
                    }
                }
                // output the result
                cell = dgData[4 + 1, i];
                cell.Value = flowerName;
                cell = dgData[4 + 2, i];
                cell.Value = Math.Round(probability * 100, 2); 
            }
        }
    }
}
