﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.Collections.ObjectModel;

/* Test application for Logistic Regression on Iris data set */
/*                  www.mosismath.com                        */

namespace WindowsFormsApplication1
{
    
    public partial class Mainwin : Form
    {

        int samples = 60;
        const int features_in = 4;
        const int features_out = 2 * features_in;    
      
        public Collection<double[]> rise = new Collection<double[]>();
        double[] offset = new double[3];
        Data data = new Data();
       
      
        double calc_probability(double[] x, double[] rise, double offset)
        {
            return 1 / (1 + 1 / Math.Exp(F_x(x, rise, offset)));
        }

        double F_x(double[] x, double[] rise, double offs)
        {
            int i;
            double res = offs;
            for (i = 0; i < features_out / 2; i++)
            {
                res = res + x[i] * x[i] * rise[2 * i] + x[i] * rise[2 * i + 1];
            }
            return res;
        }

        public Mainwin()
        {
            int i, j;
            DataGridViewCell cell;

            InitializeComponent();
            data.readData(Application.StartupPath + "\\Data_iris_test.csv");
            samples = data.values.Count;

            dgData.RowCount = samples;
            dgData.ColumnCount = features_in + 3;
            for (j = 0; j < features_in; j++)
                dgData.Columns[j].HeaderText = "x" + (j+1).ToString();
            dgData.Columns[j].HeaderText = "Id";
            dgData.Columns[j+1].HeaderText = "Flower";
            dgData.Columns[j + 2].HeaderText = "prob. [%]";
            for (i = 0; i < samples; i++)
            {
                dgData.Rows[i].HeaderCell.Value = (i+1).ToString();
    
                for (j = 0; j <= 4; j++)
                {
                    cell = dgData[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i)[j], 4).ToString();
                }
            }
            double[] line = new double[features_out];
            line[0] = -0.6017084038298; // Iris-versicolor
            line[1] = 8.8270884496564364;
            line[2] = -0.627845142235779;
            line[3] = 4.0741334313096482;
            line[4] = -1.7883831464063063;
            line[5] = 13.415805162695349;
            line[6] = -3.5467972612295027;
            line[7] = 4.5326373385152285;
            rise.Add(line);
            offset[0] = -58.25;  // cost = 0.01658061

            line = new double[features_out];
            line[0] = -8.4421284421107128; // Iris_setosa
            line[1] = -1.9660003109027489;
            line[2] = 0.56648838087534914;
            line[3] = -0.55799423357584788;
            line[4] = -8.2581663437891937;
            line[5] = -2.1398227546738373;
            line[6] = -0.81798240714849946;
            line[7] = -0.72187176270726583;
            rise.Add(line);
            offset[1] = 309;  // cost = 0.0004632837

            line = new double[features_out];
            line[0] = -0.34926926302352812; // Iris_virginica
            line[1] = -0.34432938851058559;
            line[2] = -0.25281335038390917;
            line[3] = -0.17510330900833124;
            line[4] = 1.1080407804743997;
            line[5] = -0.10680419792193016;
            line[6] = 1.3201961447181603;
            line[7] = 0.31771025988350893;
            rise.Add(line);
            offset[2] = -12.125;  // cost = 0.0116383088
        }



        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i;
            double[] x;
            double probability = 0;
            string flowerName = "";
            DataGridViewCell cell;


            for (i = 0; i < samples; i++)
            {
                x = data.values.ElementAt(i);
                probability = calc_probability(x, rise.ElementAt(0), offset[0]);
                if (probability > 0.5)
                {
                    flowerName = "Iris-versicolor";
                }
                else
                {
                    probability = calc_probability(x, rise.ElementAt(1), offset[1]);
                    if (probability > 0.5)
                    {
                        flowerName = "Iris_setosa";
                    }
                    else
                    {
                        probability = calc_probability(x, rise.ElementAt(2), offset[2]);
                        if (probability > 0.5)
                        {
                            flowerName = "Iris_virginica";
                        }
                        else
                        {
                            flowerName = "Not recognized";
                        }
                    }
                }
                // output the result
                cell = dgData[4 + 1, i];
                cell.Value = flowerName;
                cell = dgData[4 + 2, i];
                cell.Value = Math.Round(probability * 100, 2); 
            }
        }
    }
}
