﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.Collections.ObjectModel;

/* Approximation of a function f(x,y) with quadratic input as supporting points  */
/* using Gradient descent                                                        */
/*                       www.mosismath.com                                       */

namespace WindowsFormsApplication1
{
    

    public partial class Mainwin : Form
    {

        int samples = 29;
        int dataLength = 0;
        const int iterations = 2000;
        double learning_rate = 0.0002;
        const int features = 4;
        double cost = 1000;
        double[] rise = new double[features];
        double offset = 0;
        Data data = new Data();
      
        
        double cost_function(Collection<double[]> values, double[] rise)
        {
            int i, j;
            double res = 0;
            double[] dev = new double[features];
            double[] predictions = update_values(values, rise);
            double y;

            for (i = 0; i < features; i++)
            {
                dev[i] = 0;
                for (j = 0; j < samples; j++)
                {
                    y = values.ElementAt(j)[dataLength-1];
                    dev[i] += (y - predictions[j]) * (y - predictions[j]);
                }
                dev[i] = dev[i] / samples;
            }

            for (i = 0; i < features; i++)
            {
                res = res + dev[i] / 2.0;
            }
            return res;
        }


        double mean_function(Collection<double[]> values, double[] rise)
        {
            int i, j;
            double res = 0;
            double[] dev = new double[features];
            double[] predictions = update_values(values, rise);
            double y;

            for (i = 0; i < features; i++)
            {
                dev[i] = 0;
                for (j = 0; j < samples; j++)
                {
                    y = values.ElementAt(j)[dataLength - 1];
                    dev[i] +=  (y - predictions[j]);
                }
                dev[i] = dev[i] / samples;
            }

            for (i = 0; i < features; i++)
            {
                res = res + dev[i];
            }
            return res;
        }


        double[] update_values(Collection<double[]> values, double[] rise)
        {
            double[] predictions = new double[samples];
            double[] x;
            for (int i = 0; i < samples; i++)
            {
                x = values[i];
                predictions[i] = offset + x[0] * x[0] * rise[0] + x[0] * rise[1] + x[1] * x[1] * rise[2] + x[1] * rise[3];
            }
            return predictions;
        }


        double[] update_rise(Collection<double[]> values, double[] rise, double learning_rate)
        {
            int i, j;
            double[] predictions = update_values(values, rise);
            double[] d_rise = new double[features];
            double y;
            double[] tempSum = new double[features];
            for (i = 0; i < features; i++)
            {
                d_rise[i] = 0;
                tempSum[i] = 0;
            }

            for (j = 0; j < samples; j++)
            {
                y = values.ElementAt(j)[dataLength - 1];
                tempSum[0] = tempSum[0] + values.ElementAt(j)[0] * values.ElementAt(j)[0] * (y - predictions[j]);
                tempSum[1] = tempSum[1] + values.ElementAt(j)[0] * (y - predictions[j]);
                tempSum[2] = tempSum[2] + values.ElementAt(j)[1] * values.ElementAt(j)[1] * (y - predictions[j]);
                tempSum[3] = tempSum[3] + values.ElementAt(j)[1] * (y - predictions[j]);
                for (i = 0; i < features; i++)
                {
                    if (Math.Abs(tempSum[i]) > 1e15)
                    {
                        d_rise[i] = d_rise[i] - tempSum[i] / samples;
                        tempSum[i] = 0;
                    }
                }
            }

            for (i = 0; i < features; i++)
            {
                d_rise[i] = d_rise[i] - tempSum[i] / samples;
                rise[i] = rise[i] - learning_rate * d_rise[i];
            }
            return rise;
        }


        double[] find_min(Collection<double[]> values, double[] rise, double learning_rate, int maxIers)
        {
            int count = 0;
            double[] ret = new double[2];
            double oldCost = 1e20;
            cost = 1e10;
            count = 0;
            while((Math.Abs(cost - oldCost) > 1e-4) && (count < maxIers))
            {
                rise = update_rise(values, rise, learning_rate);

                cost = cost_function(values, rise);
                count++;
            }

            return rise;
        }


        public Mainwin()
        {
            int i;
            DataGridViewCell cell;

            InitializeComponent();
            data.readData(Application.StartupPath + "\\data.csv");
            gRise.ColumnCount = features + 1;
            gRise.RowCount = 1;
            samples = data.values.Count;
            dataLength = data.dataLength;
            dgDataView.RowCount = samples;
            dgDataView.ColumnCount = 5;

            dgDataView.Columns[0].HeaderText = "x";
            dgDataView.Columns[1].HeaderText = "y";
            dgDataView.Columns[2].HeaderText = "z";
            dgDataView.Columns[3].HeaderText = "f(x,y)";
            dgDataView.Columns[4].HeaderText = "dev [%]";
            for (i = 0; i < samples; i++)
            {
                dgDataView.Rows[i].HeaderCell.Value = (i + 1).ToString();
                cell = dgDataView[0, i];
                cell.Value = Math.Round(data.values.ElementAt(i)[0], 4).ToString();
                cell = dgDataView[1, i];
                cell.Value = Math.Round(data.values.ElementAt(i)[1], 4).ToString();
                cell = dgDataView[2, i];
                cell.Value = Math.Round(data.values.ElementAt(i)[2], 4).ToString();
            }
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i;
            int count = 0;
            double oldCost = 1e60;
            double divCost = 10;
            double lastCost = 10;
            double x;
            double y;
            double z;
            DataGridViewCell cell;

            offset = 0;

            rise[0] = 0;
            rise[1] = 0;
            rise[2] = 0;
            rise[3] = 0;

            while ((Math.Abs(divCost) > 0.0002) && (count < 1000))
            {
                rise = find_min(data.values, rise, learning_rate, iterations);
                divCost = oldCost - cost;
                lastCost = oldCost;
                oldCost = cost;
                offset = offset + mean_function(data.values, rise);
                count++;
            }
         
            for (i = 0; i < features; i++)
            {
                gRise.Columns[i].HeaderText = "r" + (i + 1).ToString();
                cell = gRise[i, 0];
                cell.Value = Math.Round(rise[i], 4).ToString();
            }
            gRise.Columns[i].HeaderText = "offset";
            cell = gRise[i, 0];
            cell.Value = Math.Round(offset, 4).ToString();

            tbCost.Text = Math.Round(cost, 4).ToString();
            if ((rise[0] != 0) && (rise[2] != 0))
            {
                x = -rise[1] / rise[0] / 2;
                y = -rise[3] / rise[2] / 2;
                z = x * x * rise[0] + x * rise[1] + y * y * rise[2] + y * rise[3] + offset;
                tbX0.Text = Math.Round(x,4).ToString();
                tbY0.Text = Math.Round(y,4).ToString();
                tbZ0.Text = Math.Round(z,4).ToString();
               
                for (i = 0; i < samples; i++)
                {
                    x = data.values.ElementAt(i)[0];
                    y = data.values.ElementAt(i)[1];
                    z = x * x * rise[0] + x * rise[1] + y * y * rise[2] + y * rise[3] + offset;
                    cell = dgDataView[3, i];
                    cell.Value = Math.Round(z, 4).ToString();
                    cell = dgDataView[4, i];
                    if(z != 0)
                        cell.Value = Math.Round((z -data.values.ElementAt(i)[2])/ z * 100, 4).ToString();
                }
            }
            else
                MessageBox.Show("No minimum found for Z");
        }
    }
}
