﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.ComponentModel;

/* Support vector machine using sequencial minimal oprimisation by John C. Platt */
/*                  www.mosismath.com                                            */


namespace WindowsFormsApplication1
{
    public delegate double function(double[] x1, double[] x2);

    public partial class Mainwin : Form
    {
        int samples = 0;
        const int features_in = 4;
        const int maxRuns = 2000;

        double[] lot = new double[features_in];
        double[] v = new double[features_in];
        double[] u = new double[features_in];
        double[] w = new double[features_in];
        double b = 0;
        double c = 0.9;
        double eps = 1e-6;
        int iterationCount = 0;
        TData data = new TData();
        BackgroundWorker calculationThread;

        public function K;

        public Mainwin()
        {
            int i, j;
            DataGridViewCell cell;

            InitializeComponent();

            data.readData(Application.StartupPath + "\\Data_1.csv");
            //data.readData(Application.StartupPath + "\\Data_2.csv");

            K = RBF_Kernel;

            gResult.ColumnCount = features_in + 1;
            gResult.RowCount = 1;
            samples = data.values.Count;

            dgData.RowCount = samples;
            dgData.ColumnCount = features_in + 3;
            for (j = 0; j < features_in; j++)
            {
                dgData.Columns[j].HeaderText = "x" + (j + 1).ToString();
                gResult.Columns[j].HeaderText = "w" + (j + 1).ToString();
            }
            gResult.Columns[j].HeaderText = "b";
            dgData.Columns[j].HeaderText = "y";
            dgData.Columns[j + 1].HeaderText = "f(x)";
            dgData.Columns[j + 2].HeaderText = "a";
            for (i = 0; i < samples; i++)
            {
                dgData.Rows[i].HeaderCell.Value = (i + 1).ToString();

                for (j = 0; j < features_in; j++)
                {
                    cell = dgData[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i).x[j], 2).ToString();
                }
                cell = dgData[j, i];
                cell.Value = (data.values.ElementAt(i).y).ToString();
            }
            for (j = 0; j < features_in; j++)
            {
                w[j] = 0.1;
            }
            for (i = 0; i < samples; i++)
            {
                data.values.ElementAt(i).a = 0;
            }
            calculationThread = new BackgroundWorker();
            calculationThread.DoWork += calculate;
            calculationThread.RunWorkerCompleted += calculationCompleted;
        }


        public double DotProduct(double[] x1, double[] x2)
        {
            return Vector.DotProduct(x1, x2);
        }


        public double Polynomial_Kernel(double[] x1, double[] x2)
        {
            double c = 0.5;
            int p = 2;
            return Math.Pow(Vector.DotProduct(x1, x2) + c, p);
        }


        public double SquareDotProduct_Kernel(double[] x1, double[] x2)
        {
            int i;
            double res = 0;
            for (i = 0; i < x2.Length; i++)
            {
                res = res + (x1[i] * x2[i] * x1[i] * x2[i]);
            }
            return res;
        }


        public double RBF_Kernel(double[] x1, double[] x2)
        {
            double c = 20;
            double[] temX = Vector.Sub(x1, x2);
            return -Math.Exp(Math.Sqrt(Vector.DotProduct(temX, temX) / c));
        }


        private int ComputeA1A2(int iA1, int iA2)
        {
            int i, j;
            double lLim;
            double hLim;
            double eta;
            double[] x1 = data.values.ElementAt(iA1).x;
            double[] x2 = data.values.ElementAt(iA2).x;
            double y1 = data.values.ElementAt(iA1).y;
            double y2 = data.values.ElementAt(iA2).y;
            double a1 = data.values.ElementAt(iA1).a;
            double a2 = data.values.ElementAt(iA2).a;
            double e1 = data.values.ElementAt(iA1).e;
            double e2 = data.values.ElementAt(iA2).e;
            double k11, k12, k22;
            double s = y1 * y2;
            double lObj, hObj;
            // limits for a2
            if (y1 != y2)
            {
                lLim = a2 - a1;
                if (lLim < 0)
                    lLim = 0;
                hLim = c + a2 - a1;
                if (hLim > c)
                    hLim = c;
            }
            else
            {
                lLim = a2 + a1 - c;
                if (lLim < 0)
                    lLim = 0;
                hLim = a2 + a1;
                if (hLim > c)
                    hLim = c;
            }
            if (hLim == lLim)
                return 0;

            k11 = K(x1, x1);
            k12 = K(x1, x2);
            k22 = K(x2, x2);
            eta = k11 + k22 - 2 * k12;
            // calculate a2
            if (eta > 0)
            {
                a2 = data.values.ElementAt(iA2).a + y2 * (e1 - e2) / eta;

                if (a2 > hLim)
                    a2 = hLim;
                else
                {
                    if (a2 < lLim)
                        a2 = lLim;
                }
            }
            else
            {
                double f1 = y1 * (e1 - b) - a1 * k11 - s * a2 * k12;
                double f2 = y2 * (e2 - b) - s * a1 * k12 - a2 * k22;
                double l1 = a1 + s * (a2 - lLim);
                double h1 = a1 + s * (a2 - hLim);
                lObj = l1 * f1 + lLim * f2 + l1 * l1 * k11 / 2 + lLim * lLim * k22 / 2 + s * lLim * l1 * k12;
                hObj = h1 * f1 + hLim * f2 + h1 * h1 * k11 / 2 + hLim * hLim * k22 / 2 + s * hLim * h1 * k12;
                if (lObj < hObj - eps)
                    a2 = lLim;
                else
                {
                    if (lObj > hObj + eps)
                        a2 = hLim;
                }
            }

            if (Math.Abs(a2 - data.values.ElementAt(iA2).a) < eps * (a2 + data.values.ElementAt(iA2).a + eps))
                return 0;
            // calculate a1
            a1 = data.values.ElementAt(iA1).a + y1 * y2 * (data.values.ElementAt(iA2).a - a2);
            // calculate b
            double b1 = e1 + y1 * (a1 - data.values.ElementAt(iA1).a) * k11 + y2 * (a2 - data.values.ElementAt(iA2).a) * k12;
            double b2 = e2 + y1 * (a1 - data.values.ElementAt(iA1).a) * k12 + y2 * (a2 - data.values.ElementAt(iA2).a) * k22;
            if ((a1 > lLim) && (a1 < hLim))
                b = b - b1;
            else
            {
                if ((a2 > lLim) && (a2 < hLim))
                    b = b - b2;
                else
                    b = b - (b1 + b2) / 2;
            }
            // update values
            data.values.ElementAt(iA2).a = a2;
            data.values.ElementAt(iA1).a = a1;
            // update all error values
            for (j = 0; j < samples; j++)
            {
                double tempU = 0;
                for (i = 0; i < samples; i++)
                {
                    tempU = tempU + data.values.ElementAt(i).y * data.values.ElementAt(i).a * K(data.values.ElementAt(i).x, data.values.ElementAt(j).x);
                }
                data.values.ElementAt(j).e = tempU + b - data.values.ElementAt(j).y;
            }
            return 1;
        }

        private void calculate(object sender, System.ComponentModel.DoWorkEventArgs e)
        {
            int i, j;
            int numChanged = 1;
            bool firstRun = true;

            for (j = 0; j < samples; j++)
            {
                double tempU = 0;
                for (i = 0; i < samples; i++)
                {
                    tempU = tempU + data.values.ElementAt(i).y * data.values.ElementAt(i).a * K(data.values.ElementAt(i).x, data.values.ElementAt(j).x);
                }
                data.values.ElementAt(j).e = tempU + b - data.values.ElementAt(j).y;
            }
            // Loop to optimize a1 ana a2
            while ((numChanged > 0) && (iterationCount < maxRuns))
            {
                numChanged = 0;
                for (i = 0; i < samples; i++)
                {
                    if (firstRun)
                    {
                        for (j = 0; j < samples; j++)
                        {
                            if (j != i)
                                numChanged += ComputeA1A2(i, j);
                        }
                    }
                    else
                    {
                        if ((data.values.ElementAt(i).a > 0) && (data.values.ElementAt(i).a < c))
                        {
                            for (j = 0; j < samples; j++)
                            {
                                if (j != i)
                                    numChanged += ComputeA1A2(i, j);
                            }
                        }
                    }
                }
                firstRun = false;
                iterationCount++;
            }
        }

        void calculationCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            int i, j;
            DataGridViewCell cell;

            if (iterationCount < maxRuns)
            {
                // compute result and display
                Vector.Clear(w);
                for (i = 0; i < samples; i++)
                {
                    cell = dgData[features_in + 1, i];
                    double fx = b;
                    for (j = 0; j < samples; j++)
                    {
                        if (data.values.ElementAt(j).a > 0)
                            fx = fx + data.values.ElementAt(j).y * data.values.ElementAt(j).a * K(data.values.ElementAt(j).x, data.values.ElementAt(i).x);
                    }
                    cell.Value = (fx).ToString();
                    cell = dgData[features_in + 2, i];
                    cell.Value = (data.values.ElementAt(i).a).ToString();

                    w = Vector.Add(w, Vector.Mult(data.values.ElementAt(i).x, data.values.ElementAt(i).a * data.values.ElementAt(i).y));
                }
                for (i = 0; i < features_in; i++)
                {
                    cell = gResult[i, 0];
                    cell.Value = (w[i]).ToString();
                }

                cell = gResult[i, 0];
                cell.Value = (b).ToString();
                data.parameter.b = b;
                data.parameter.w = Vector.Assign(w);
                data.writeTrainedData("Trained.Json");
            }
            else
                MessageBox.Show("No convergation", "Calculation error!");
            Cursor.Current = Cursors.Default;
            this.Cursor = Cursors.Default;
            dgData.Cursor = Cursors.Default;
            bt_Calc.Enabled = true;
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            iterationCount = 0;
            this.Cursor = Cursors.WaitCursor;
            Cursor.Current = Cursors.WaitCursor;
            bt_Calc.Enabled = false;
            calculationThread.RunWorkerAsync();
        }
    }
}
