﻿using System;

namespace WindowsFormsApplication1
{
    static public class Vector
    {
        static public void Clear(double[] x1)
        {
            int i;
            for (i = 0; i < x1.Length; i++)
            {
               x1[i] = 0;
            }
        }

        static public double[] Assign(double[] x)
        {
            int i;
            double[] res = new double[x.Length];
            for (i = 0; i < x.Length; i++)
            {
                res[i] = x[i];
            }
            return res;
        }

        static public double Dist(double[] x1, double[] x2)
        {
            int i;
            double res = 0;
            for (i = 0; i < x2.Length; i++)
            {
                res = res + (x1[i] - x2[i]) * (x1[i] - x2[i]);
            }
            return Math.Sqrt(res);
        }

        static public double Length(double[] x)
        {
            int i;
            double res = 0;
            for (i = 0; i < x.Length; i++)
            {
                res = res + (x[i] * x[i]);
            }
            return Math.Sqrt(res);
        }

        static public double[] Mult(double[] x1, double[] x2)
        {
            int i, j;
            double[] res = new double[x1.Length];
            for (i = 0; i < x2.Length; i++)
            {      
                res[i] =  (x1[i] * x2[i]);
            }
            return res;
        }

        static public double[] Mult(double[] x1, double x2)
        {
            int i, j;
            double[] res = new double[x1.Length];
            for (i = 0; i < x1.Length; i++)
            {
                res[i] = x1[i] * x2;
            }
            return res;
        }

        static public double DotProduct(double[] x1, double[] x2)
        {
            int i;
            double res = 0;
            for (i = 0; i < x2.Length; i++)
            {
                res = res + (x1[i] * x2[i]);
            }
            return res;
        }

        static public double[] Add(double[] x1, double[] x2)
        {
            int i, j;
            double[] res = new double[x1.Length];
            for (i = 0; i < x2.Length; i++)
            {
                res[i] = (x1[i] + x2[i]);
            }
            return res;
        }

        static public double[] Sub(double[] x1, double[] x2)
        {
            int i, j;
            double[] res = new double[x1.Length];
            for (i = 0; i < x2.Length; i++)
            {
                res[i] = (x1[i] - x2[i]);
            }
            return res;
        }

        static public double[] Div(double[] x1, double x2)
        {
            int i, j;
            double[] res = new double[x1.Length];
            for (i = 0; i < x1.Length; i++)
            {
                res[i] = (x1[i] / x2);
            }
            return res;
        }
    }
}
