﻿using System;
using System.Linq;
using System.Windows.Forms;
using System.Diagnostics;

/*  Test application to Support Vector Machine with Iris data  */
/*                     www.mosismath.com                       */


namespace WindowsFormsApplication1
{
    public delegate double function(double[] x1, double[] x2);

    public partial class Mainwin : Form
    {

        int samples = 60;
        const int features_in = 4;
       
        double[] lot = new double[features_in];
        double[] v = new double[features_in];
        double[] u = new double[features_in];
        double[] w = new double[features_in];
        double b = 0;
        double c = 0.8;
        double eps = 1e-6;  
        TData data = new TData();
        Stopwatch timer = new Stopwatch();
        public function K;

        public Mainwin()
        {
            int i, j;
            DataGridViewCell cell;

            InitializeComponent();

            data.readData(Application.StartupPath + "\\Data_iris_test.csv");

            K = RBF_Kernel;

            samples = data.values.Count;

            dgData.RowCount = samples;
            dgData.ColumnCount = features_in + 3;
            for (j = 0; j < features_in; j++)
            {
                dgData.Columns[j].HeaderText = "x" + (j + 1).ToString();
            }
            dgData.Columns[j].HeaderText = "y";
            dgData.Columns[j+1].HeaderText = "class";
            dgData.Columns[j+2].HeaderText = "f(x)";
            for (i = 0; i < samples; i++)
            {
                dgData.Rows[i].HeaderCell.Value = (i + 1).ToString();

                for (j = 0; j < features_in; j++)
                {
                    cell = dgData[j, i];
                    cell.Value = Math.Round(data.values.ElementAt(i).x[j], 2).ToString();
                }
                cell = dgData[j, i];
                cell.Value = (data.values.ElementAt(i).y).ToString();
            }
            for (j = 0; j < features_in; j++)
            {
                w[j] = 0.1;
            }
            for (i = 0; i < samples; i++)
            {
                data.values.ElementAt(i).a = 0;
            }
        }


        public double DotProduct(double[] x1, double[] x2)
        {
            return Vector.DotProduct(x1, x2);
        }


        public double Polynomial_Kernel(double[] x1, double[] x2)
        {
            double c = 0.5;
            int p = 2;
            return Math.Pow(Vector.DotProduct(x1, x2) + c, p);
        }


        public double SquareDotProduct_Kernel(double[] x1, double[] x2)
        {
            int i;
            double res = 0;
            for (i = 0; i < x2.Length; i++)
            {
                res = res + (x1[i] * x2[i] * x1[i] * x2[i]);
            }
            return res;
        }


        public double RBF_Kernel(double[] x1, double[] x2)
        {
            double c = 20;
            double[] temX = Vector.Sub(x1, x2);
            return -Math.Exp(Math.Sqrt(Vector.DotProduct(temX, temX) / c));
        }

      
        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i,j;
            double fx;
            DataGridViewCell cell;

            for (j = 0; j < samples; j++)
            {
                double tempU = 0;
                for (i = 0; i < data.setting.Count; i++)
                {
                    tempU = tempU + data.setting.ElementAt(i).y * data.setting.ElementAt(i).a * K(data.setting.ElementAt(i).x, data.values.ElementAt(j).x);
                }
                data.values.ElementAt(j).e = tempU - b - data.values.ElementAt(j).y;
            }

            for (i = 0; i < samples; i++)
            {
                // First step of classification
                data.readTrainedData(Application.StartupPath + "\\Trained_1.Json");
                fx = data.b;
                cell = dgData[features_in + 1, i];
                for (j = 0; j < data.setting.Count; j++)
                {
                    if(data.setting.ElementAt(j).a > 0)
                        fx = fx + data.setting.ElementAt(j).y * data.setting.ElementAt(j).a * K(data.setting.ElementAt(j).x, data.values.ElementAt(i).x);
                }
                if (fx > 0)
                {
                    cell.Value = "Iris-setosa";
                    cell = dgData[features_in + 2, i];
                    cell.Value = (Math.Round(fx, 3)).ToString();
                }
                else
                {
                    // Second step of classification
                    data.readTrainedData(Application.StartupPath + "\\Trained_2.Json");
                    fx = data.b;
                    for (j = 0; j < data.setting.Count; j++)
                    {
                        if (data.setting.ElementAt(j).a > 0)
                            fx = fx + data.setting.ElementAt(j).y * data.setting.ElementAt(j).a * K(data.setting.ElementAt(j).x, data.values.ElementAt(i).x);
                    }
                    if (fx > 0)
                    {
                        cell.Value = "Iris-versicolor";
                    }
                    else
                    {
                        cell.Value = "Iris-virginica";
                    }
                    cell = dgData[features_in + 2, i];
                    cell.Value = (Math.Round(fx, 3)).ToString();
                }
              
            }
        }
    }
}
