﻿using System;
using System.Collections.ObjectModel;
using System.IO;
using System.Linq;
using System.Text;
using System.Runtime.Serialization.Json;
using System.Runtime.Serialization;

namespace WindowsFormsApplication1
{
    public class TElement
    {
        public double[] x;
        public int y;
        public double a;
        public double e;
    }

    public struct TParameter
    {
        public double b;
        public double[] w;
    };

    [Serializable]
    public class ParameterTable
    {
        [DataMember]
        public TElement[] element;

        [DataMember]
        public TParameter par;
    }

    public class TData
    {
        public double b;
        public Collection<TElement> values = new Collection<TElement>();
        public Collection<TElement> setting = new Collection<TElement>();
        public TParameter parameter = new TParameter();

        public void readData(string FileName)
        {
            foreach (var str in File.ReadLines(FileName, Encoding.Default))
            {
                int i;
                TElement tempEl = new TElement();
                string[] strLine = str.Split(',');
                tempEl.x = new double[strLine.Length-1];
                tempEl.a = 0;
                for (i = 0; i < strLine.Length-1; i++)
                    tempEl.x[i] = Convert.ToDouble(strLine[i]);
                tempEl.y = Convert.ToInt32(strLine[i]);
                values.Add(tempEl);
            }
        }


        public void writeTrainedData(string FileName)
        {
            int i;
            MemoryStream ms = new MemoryStream();
            byte[] startBytes = Encoding.ASCII.GetBytes("{\n \"element\": [");
            byte[] eol = Encoding.ASCII.GetBytes(",\n");
            ms.Write(startBytes, 0, startBytes.Length);
            DataContractJsonSerializer ser = new DataContractJsonSerializer(typeof(TElement));
            for (i = 0; i < values.Count; i++)
            {
                TElement tempEl = values.ElementAt(i);
                if (tempEl.a > 0)
                {
                    ser.WriteObject(ms, tempEl);
                    if (i < values.Count - 1)
                        ms.Write(eol, 0, eol.Length);
                }
            }

            byte[] endBytes = Encoding.ASCII.GetBytes("],\n  \"par\": {");
            ms.Write(endBytes, 0, endBytes.Length);

            DataContractJsonSerializer par = new DataContractJsonSerializer(typeof(TParameter));
            par.WriteObject(ms, parameter);
            ms.Write(eol, 0, eol.Length);

            endBytes = Encoding.ASCII.GetBytes("}");
            ms.Write(endBytes, 0, endBytes.Length);

            using (FileStream fs = new FileStream(FileName, FileMode.OpenOrCreate))
            {
                ms.Position = 0;
                fs.Write(ms.ToArray(), 0, ms.ToArray().Length);
                ms.Close();
                fs.Close();
            }
        }


        public void readTrainedData(string FileName)
        {
            int i, j;
            setting.Clear();
            using (StreamReader r = new StreamReader(FileName))
            {
                string response = r.ReadToEnd();
                ParameterTable table = new ParameterTable();
                MemoryStream m = new MemoryStream(Encoding.UTF8.GetBytes(response));
                DataContractJsonSerializer ser = new DataContractJsonSerializer(table.GetType());
                table = ser.ReadObject(m) as ParameterTable;
                for (i = 0; i < table.element.Length; i++)
                {
                    TElement tempEl = new TElement();
                    tempEl.a = table.element[i].a;
                    tempEl.y = table.element[i].y;
                    tempEl.x = new double[table.element[i].x.Length];
                    for (j = 0; j < table.element[i].x.Length; j++)
                        tempEl.x[j] = table.element[i].x[j];
                    setting.Add(tempEl);
                }
                b = table.par.b;
            }
        }
    }
}

