﻿
using System;
using System.Windows.Forms;

/*     Solving a matrix equation by the use of deeterminants       */
/*                       www.mosismath.com                         */

namespace WindowsFormsApplication1
{

   
    public partial class MainWin : Form
    {
        public const int MaxOrder = 4;

        public TextBox[,] tbm;
        public TextBox[] tbs;
        public TextBox[] tbx;

        public double[,] m = new double[MaxOrder, MaxOrder];
        public double[] y = new double[MaxOrder];
        public double[] x = new double[MaxOrder];

        
        double CalcDet(double[,] m, int order)
        {
            int i,j, k;
            double sign = 1.0;
            double dm = 0;
            if (order <= 2)
            {
                return m[0, 0] * m[1, 1] - m[1, 0] * m[0, 1]; 
            }
            else
            {
                double[,] mm = new double[order - 1, order - 1]; // temporary matrix
                for (i = 0; i < order; i++) // index for the element of the top row
                {
                    for(j=0; j < order-1; j++) // index to copy the elements into a sub matrix
                    {
                        for(k=0; k < order-1; k++) // index that runs down from second row to n
                        {
                            if (j < i)
                                mm[k, j] = m[k+1, j];
                            else
                                mm[k, j] = m[k+1, j + 1];
                        }                        
                    }
                    dm = dm + sign * CalcDet(mm, order - 1) * m[0, i];
                    sign = -sign;
                }
                return dm;
            }
        }

        void SolveMatrix()
        {
            int i, k;
            double det, detx;
            double[] buf = new double[MaxOrder];

            det = CalcDet(m, MaxOrder);

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    buf[k] = m[k, i];
                    m[k, i] = y[k];
                }
                detx = CalcDet(m, MaxOrder);
                if (det != 0)
                    x[i] = detx / det;
                for (k = 0; k < MaxOrder; k++)
                {
                    m[k, i] = buf[k];
                }
            }        
        }

        public MainWin()
        {
            int i, k;
            //m = new TMatrix(MaxOrder);
            tbm = new TextBox[5, 5];
            tbs = new TextBox[5];
            tbx = new TextBox[5];

            InitializeComponent();
            tbm[0, 0] = textBox1;  tbm[0, 1] = textBox2;  tbm[0, 2] = textBox3;  tbm[0, 3] = textBox4;  tbm[0, 4] = textBox5;
            tbm[1, 0] = textBox6;  tbm[1, 1] = textBox7;  tbm[1, 2] = textBox8;  tbm[1, 3] = textBox9;  tbm[1, 4] = textBox10;
            tbm[2, 0] = textBox11; tbm[2, 1] = textBox12; tbm[2, 2] = textBox13; tbm[2, 3] = textBox14; tbm[2, 4] = textBox15;
            tbm[3, 0] = textBox16; tbm[3, 1] = textBox17; tbm[3, 2] = textBox18; tbm[3, 3] = textBox19; tbm[3, 4] = textBox20;
            tbm[4, 0] = textBox21; tbm[4, 1] = textBox22; tbm[4, 2] = textBox23; tbm[4, 3] = textBox24; tbm[4, 4] = textBox25;

            tbs[0] = textBox26; tbs[1] = textBox27; tbs[2] = textBox28; tbs[3] = textBox29; tbs[4] = textBox30;

            tbx[0] = textBox31; tbx[1] = textBox32; tbx[2] = textBox33; tbx[3] = textBox34; tbx[4] = textBox35;
 
            m[0, 0] = 3.0;
            m[0, 1] = -5.0;
            m[0, 2] = 4.0;
            m[0, 3] = -3.0;

            m[1, 0] = 2.0;
            m[1, 1] = 0.0;
            m[1, 2] = -3.0;
            m[1, 3] = 2.0;

            m[2, 0] = 3.0;
            m[2, 1] = 2.0;
            m[2, 2] = 0.0;
            m[2, 3] = 4.0;

            m[3, 0] = 5.0;
            m[3, 1] = -2.0;
            m[3, 2] = 3.0;
            m[3, 3] = -3.0;

            y[0] = -2.5;
            y[1] = -1.7;
            y[2] = 14.8;
            y[3] = 4.0;


            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    tbm[i, k].Text = Convert.ToString(m[i, k]);

                }
                tbs[i].Text = Convert.ToString(y[i]);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    m[i, k] = Convert.ToDouble(tbm[i, k].Text);
                }
                y[i] = Convert.ToDouble(tbs[i].Text);
            }

            SolveMatrix();

            for (i = 0; i < MaxOrder; i++)
            {
              tbx[i].Text = Convert.ToString(x[i]);
            }        
        }    
    }
}
