﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

// To compute eigenvalues of a 3x3 matrix by the use of Cardano
// www.mosismath.com

namespace WindowsFormsApplication1
{
    public struct TKomplex
    {
        public double real;
        public double imag;
    };

    public partial class Mainwin : Form
    {
         TKomplex x1, x2, x3;
         double a1, a, b, c, d;
         double[,] m = new double[3, 3];

        public double Xroot(double a, double x)
        {
            double i = 1;
            if (a < 0)
                i = -1;
            return (i * Math.Exp( Math.Log(a*i)/x));
        }

        public int Calc_Cardano()  // solve cubic equation according to cardano
        {
            double p, q, u, v;
            double r, alpha;
            int res;
            res = 0;
            if (a1 != 0)
            {
                a = b / a1;
                b = c / a1;
                c = d / a1;

                p = -(a * a / 3.0) + b;
                q = (2.0 / 27.0 * a * a * a) - (a * b / 3.0) + c;
                d = q * q / 4.0 + p * p * p / 27.0;
                if (Math.Abs(d) < Math.Pow(10.0, -11.0))
                    d = 0;
                // 3 cases D > 0, D == 0 and D < 0
                if (d > 1e-20)
                {
                    u = Xroot(-q / 2.0 + Math.Sqrt(d), 3.0);
                    v = Xroot(-q / 2.0 - Math.Sqrt(d), 3.0);
                    x1.real = u + v - a / 3.0;
                    x2.real = -(u + v) / 2.0 - a / 3.0;
                    x2.imag = Math.Sqrt(3.0) / 2.0 * (u - v);
                    x3.real = x2.real;
                    x3.imag = -x2.imag;
                    res = 1;
                }
                if (Math.Abs(d) <= 1e-20)
                {
                    u = Xroot(-q / 2.0, 3.0);
                    v = Xroot(-q / 2.0, 3.0);
                    x1.real = u + v - a / 3.0;
                    x2.real = -(u + v) / 2.0 - a / 3.0;
                    res = 2;
                }
                if (d < -1e-20)
                {
                    r = Math.Sqrt(-p * p * p / 27.0);
                    alpha = Math.Atan(Math.Sqrt(-d) / -q * 2.0);
                    if (q > 0)                         // if q > 0 the angle becomes PI + alpha
                        alpha = Math.PI + alpha;

                    x1.real = Xroot(r, 3.0) * (Math.Cos((6.0 * Math.PI - alpha) / 3.0) + Math.Cos(alpha / 3.0)) - a / 3.0;
                    x2.real = Xroot(r, 3.0) * (Math.Cos((2.0 * Math.PI + alpha) / 3.0) + Math.Cos((4.0 * Math.PI - alpha) / 3.0)) - a / 3.0;
                    x3.real = Xroot(r, 3.0) * (Math.Cos((4.0 * Math.PI + alpha) / 3.0) + Math.Cos((2.0 * Math.PI - alpha) / 3.0)) - a / 3.0;
                    res = 3;
                }
            }
            else
                res = 0;
            return res;
        }


        public Mainwin()
        {
            int i;
            InitializeComponent();
            GMatrixA.ColumnCount = 3;
           
            //Sample matrixes

          /*  GMatrixA.Rows.Add(new object[] {  3 ,  0 ,  4  });
            GMatrixA.Rows.Add(new object[] { -13,  3 ,  4  });
            GMatrixA.Rows.Add(new object[] {  11,  -11 ,-10 });*/
            /*
              real Eigenvalue:   { 8,55259149312143 }
              complex Eigenvalues: { -6,276295746560715-4,118895352203385î ;  -6,276295746560715+4,118895352203385î }
            */

            GMatrixA.Rows.Add(new object[] { 9, -8, -10 });
            GMatrixA.Rows.Add(new object[] {-18, 10,   8  });
            GMatrixA.Rows.Add(new object[] { 10, -11, -16 });
            /* real Eigenvalues:   { -11,504646459138934 ;  -0,21261901394173544 ;  14,717265473080671 } */
     
            for (i = 0; i < GMatrixA.ColumnCount; i++)
                GMatrixA.Columns[i].Width = 160;
            x1 = new TKomplex();
            x2 = new TKomplex();
            x3 = new TKomplex();
            x1.real = 0;
            x1.imag = 0;
            x2.real = 0;
            x2.imag = 0;
            x3.real = 0;
            x3.imag = 0;
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            DataGridViewCell cell;
            int i, k;
            for (i = 0; i <3; i++)
            {
                for (k = 0; k < 3; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    m[k, i] = Convert.ToDouble(cell.Value);
                }
            }
            a1 = 1.0;
            b = -(m[0, 0] + m[1, 1] + m[2, 2]);
            c = m[0, 0] * m[1, 1] - m[0, 1] * m[1, 0] + m[0, 0] * m[2, 2] - m[0, 2] * m[2, 0] + m[1, 1] * m[2, 2] - m[1, 2] * m[2, 1];
            d = -m[0, 0] * (m[1, 1] * m[2, 2] - m[1, 2] * m[2, 1]) + m[0, 1] * (m[1, 0] * m[2, 2] - m[1, 2] * m[2, 0]) - m[0, 2] * (m[1, 0] * m[2, 1] - m[1, 1] * m[2, 0]);

            tb_A.Text = Convert.ToString(a1);
            tb_B.Text = Convert.ToString(b);
            tb_C.Text = Convert.ToString(c);
            tb_D.Text = Convert.ToString(d);

            if ((a1 != 0) && (b != 0) && (c != 0) && (d != 0))
            {
                switch (Calc_Cardano())
                {
                    case 0:
                        {
                            tb_x1.Text = "";
                            tb_x2.Text = "";
                            tb_x3.Text = "";
                            break;
                        }
                    case 1:
                        {
                            tb_x1.Text = Convert.ToString(Math.Round(x1.real, 3));
                            tb_x2.Text = Convert.ToString(Math.Round(x2.real, 3)) + " " + Convert.ToString(Math.Round(x2.imag, 3)) + "i";
                            tb_x3.Text = Convert.ToString(Math.Round(x3.real, 3)) + " " + Convert.ToString(Math.Round(x3.imag, 3)) + "i";
                            break;
                        }
                    case 2:
                        {
                            tb_x1.Text = Convert.ToString(Math.Round(x1.real, 3));
                            tb_x2.Text = Convert.ToString(Math.Round(x2.real, 3));
                            tb_x3.Text = "";
                            break;
                        }
                    case 3:
                        {
                            tb_x1.Text = Convert.ToString(Math.Round(x1.real, 3));
                            tb_x2.Text = Convert.ToString(Math.Round(x2.real, 3));
                            tb_x3.Text = Convert.ToString(Math.Round(x3.real, 3));
                            break;
                        }
                }
            }
        }
    }
}
