﻿
using System;
using System.Windows.Forms;


/*     Inverse Vector iteration        */
/*    www.mosismath.com                */

namespace WindowsFormsApplication1
{

     public partial class MainWin : Form
    {
        public int MaxOrder = 4;
        public double[] eigenVect;
        public double eigenvalue = 0;
        public double eigenvalOld = -1E10;
        //public double u = 0;
        public double shift = -2.0;

        TGauss gauss;

        TMatrix m;
        TMatrix ori;

        public MainWin()
        {
            int i, k;
            m = new TMatrix(MaxOrder); // equation Matrix
            ori = new TMatrix(MaxOrder); // equation Matrix origin
            eigenVect = new double[MaxOrder];
            DataGridViewCell cell;

            InitializeComponent();
          
            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
            for(i = 0; i < GMatrixA.ColumnCount; i++)
                GMatrixA.Columns[i].Width = 160;
            GSolution.ColumnCount = 1;
            GSolution.RowCount = MaxOrder;
            GEigenvector.ColumnCount = MaxOrder;
            GEigenvector.RowCount = 2;

            m.a[0, 0] = 20.0;
            m.a[0, 1] = -7.0;
            m.a[0, 2] = 3.0;
            m.a[0, 3] = -2.0;

            m.a[1, 0] = -7.0;
            m.a[1, 1] = 5.0;
            m.a[1, 2] = 1.0;
            m.a[1, 3] = 4.0;

            m.a[2, 0] = 3.0;
            m.a[2, 1] = 1.0;
            m.a[2, 2] = 3.0;
            m.a[2, 3] = 1.0;

            m.a[3, 0] = -2.0;
            m.a[3, 1] = 4.0;
            m.a[3, 2] = 1.0;
            m.a[3, 3] = 2.0;

            tbStartVal.Text = shift.ToString();
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m.a[k, i]);
                    ori.a[k, i] = m.a[k, i];
                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(m.y[i]);
                eigenVect[i] = Math.Sqrt(1.0 / (double)MaxOrder);
                m.y[i] = eigenVect[i];
            }
        }

        private void RunVector(TMatrix m)
        {
            int i, k;
            double len = 0.0;
            double[] y = new double[MaxOrder];
            gauss = new TGauss(MaxOrder, m);
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    m.a[k, i] = ori.a[k, i];
                }
                m.a[i, i] = m.a[i, i] - shift;
                m.x[i] = 0;
            }
            gauss.Eliminate();
            gauss.Solve();

            // calculate the length of x
            len = 0;
            for (i = 0; i < MaxOrder; i++)
            {
                len = len + m.x[i] * m.x[i];
            }
            len = Math.Sqrt(len);

            // narmalize the eigenvector and set y for the next loop
            for (i = 0; i < MaxOrder; i++)
            {
                eigenVect[i] = m.x[i] / len; // eigenvector to u
                m.y[i] = eigenVect[i]; // set y for the next iteration
            }

            // calculate the eigenvalue
            for (i = 0; i < MaxOrder; i++)
            {
                y[i] = 0;
                for (k = 0; k < MaxOrder; k++)
                {
                    y[i] = y[i] + ori.a[k, i] * eigenVect[k];
                }
            }
            eigenvalue = 0;
            for (i = 0; i < MaxOrder; i++)
            {
                eigenvalue = eigenvalue + y[i] / eigenVect[i];
            }
            eigenvalue = eigenvalue / MaxOrder;
        }

        private void button3_Click(object sender, EventArgs e)
        {
            int i, k;
            int count = 0;
            double delta = 10;
            DataGridViewCell cell;
            try
            {
                shift = Convert.ToDouble(tbStartVal.Text);
            }
            catch
            {
                MessageBox.Show("No valid start value!");
            }
            tbStartVal.Text = shift.ToString();
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    m.a[k, i] = Convert.ToDouble(cell.Value);
                    ori.a[k, i] = m.a[k, i];
                }
                cell = GSolution[0, i];
                m.y[i] = Convert.ToDouble(cell.Value);
                eigenVect[i] = Math.Sqrt(1.0 / (double)MaxOrder);
                m.y[i] = eigenVect[i];
            }

            while ((delta > 1E-20) && (count < 100))
            {
                RunVector(m);
                delta = Math.Abs(eigenvalOld - eigenvalue);
                eigenvalOld = eigenvalue;
                count++;
            }
           
            for (i = 0; i < MaxOrder; i++)
            {
                cell = GEigenvector[i,0];
                cell.Value = Convert.ToString(eigenVect[i]);  // eigenvector to u
                cell = GSolution[0,i];
                cell.Value = Convert.ToString(eigenVect[i]);
            }

            tbEigenvalue.Text = Convert.ToString(eigenvalue);
        }
    }
}
