﻿using System;

namespace WindowsFormsApplication1
{
    public class TMatrix
    {
        public int size;
        public double[,] a;
        public double[] y;
        public double[] x;

        public TMatrix(int iSize)
        {
            size = iSize;
            a = new double[size, size];
            y = new double[size];
            x = new double[size];
        }

        public void MultMatrixRight(TMatrix matrix2, int p, int q)
        {
            int i, j, k;
            double[,] al = new double[size, size];
            double[] yl = new double[size];
            for (i = 0; i < size; i++)
            {
                for (j = 0; j < size; j++)
                {
                    al[i, j] = 0.0;
                    for (k = 0; k < size; k++)
                    {
                        al[i, j] = al[i, j] + (a[i, k] * matrix2.a[k, j]);
                    }
                }


            }
            for (i = 0; i < size; i++)
            {
                for (j = 0; j < size; j++)
                {
                    a[i, j] = al[i, j];
                }
            }
        }

        public void MultTranspMatrixLeft(TMatrix matrix2, int p, int q)
        {
            int i, j, k;
            double[,] al = new double[size, size];
            double[] yl = new double[size];
            for (i = 0; i < size; i++)
            {
                if ((i == p) || (i == q)) // only calculate row p and q
                {
                    yl[i] = 0.0;
                    for (j = 0; j < size; j++)
                    {
                        al[i, j] = 0.0;
                        for (k = 0; k < size; k++)
                        {
                            al[i, j] = al[i, j] + (matrix2.a[k, i] * a[k, j]);
                        }
                    }
                }
                else
                {
                    for (j = 0; j < size; j++)
                    {
                        al[i, j] = a[i, j];
                    }
                }
            }
            for (i = 0; i < size; i++)
            {
                for (j = 0; j < size; j++)
                {
                    a[i, j] = al[i, j];
                }
            }
        }


        public void MultMatrixLeft(TMatrix matrix2, int p, int q)
        {
            int i, j, k;
            double[,] al = new double[size, size];
            double[] yl = new double[size];
            for (i = 0; i < size; i++)
            {
                if ((i == p) || (i == q)) // only calculate row p and q
                {
                    yl[i] = 0.0;
                    for (j = 0; j < size; j++)
                    {
                        al[i, j] = 0.0;
                        for (k = 0; k < size; k++)
                        {
                            al[i, j] = al[i, j] + (matrix2.a[i, k] * a[k, j]);
                        }
                    }

                }
                else
                {
                    for (j = 0; j < size; j++)
                    {
                        al[i, j] = a[i, j];
                    }
                }
            }
            for (i = 0; i < size; i++)
            {
                for (j = 0; j < size; j++)
                {
                    a[i, j] = al[i, j];
                }
            }
        }
    }
}
