﻿
using System;
using System.Windows.Forms;
using System.Diagnostics;



namespace WindowsFormsApplication1
{

     public partial class MainWin : Form
    {
        const int MaxOrder = 4;
        public TextBox[,] tbm;
        public TextBox[] tbs;
        public TextBox[] tbx;

        Stopwatch timer = new Stopwatch();

        public double[,] a = new double[MaxOrder, MaxOrder];
        public double[] x1 = new double[MaxOrder];
        double eigenval = 0;

        public double[] MultMatrixRight(double[,] a, double[] z, int size)
        {
            int i, k;
            double[] al = new double[size];
            for (i = 0; i < size; i++)
            {
                al[i] = 0.0;
                for (k = 0; k < size; k++)
                {
                    al[i] = al[i] + (a[i, k] * z[k]);
                }
            }
            return al;
        }


        public void RunVector(int maxOrder)
        {
            int i, k, count = 0;
            double[] x2 = new double[maxOrder];
            double[] y = new double[maxOrder];
            double delta = 10;
            double oldZ = 1E30;
            double lenW = 0; 

            while ((delta > 1.0E-50) && (count < 150))
            {    
                count++;
                // multiplication A * xn
                x2 = MultMatrixRight(a, x1, maxOrder);

                for (i = 0; i < MaxOrder; i++)
                {
                    y[i] = 0;
                    for (k = 0; k < maxOrder; k++)
                    {
                        y[i] = y[i] + a[k, i] * x1[k];
                    }
                }

                // calculate the eigenvalue
                eigenval = 0;
                for (i = 0; i < maxOrder; i++)
                {
                    eigenval = eigenval + y[i] / x1[i];
                }
                eigenval = eigenval / maxOrder;

                // set xn+1 for the next iteration
                for (i = 0; i < maxOrder; i++)
                {
                    x1[i] = x2[i] / eigenval;
                }

                // normalize x1
                lenW = 0.0;
                for (i = 0; i < maxOrder; i++)
                {
                    lenW = lenW + x1[i] * x1[i];
                }
                lenW = Math.Sqrt(lenW);
                for (i = 0; i < maxOrder; i++)
                {
                    x1[i] = x1[i] / lenW;
                }

                // check the delta between the last iteration and the current 
                delta = Math.Abs(oldZ - eigenval);
                oldZ = eigenval;
            }
        }
        
        public MainWin()
        {
            int i, k;
         
            DataGridViewCell cell;

            InitializeComponent();

            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
 
            for (i = 0; i < GMatrixA.ColumnCount; i++)
            {
                GMatrixA.Columns[i].Width = 160;
            }
            GSearched.ColumnCount = MaxOrder;
            GSearched.RowCount = 1;
          
            a[0, 0] = 20.0;
            a[0, 1] = -7.0;
            a[0, 2] = 3.0;
            a[0, 3] = -2.0; 
         
            a[1, 0] = -7.0;
            a[1, 1] = 5.0;
            a[1, 2] = 1.0;
            a[1, 3] = 4.0;
             
            a[2, 0] = 3.0;
            a[2, 1] = 1.0;
            a[2, 2] = 3.0;
            a[2, 3] = 1.0;

            a[3, 0] = -2.0;
            a[3, 1] = 4.0;
            a[3, 2] = 1.0;
            a[3, 3] = 2.0;

            for (i = 0; i < MaxOrder; i++)
                x1[i] = 1 / (double)MaxOrder;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(a[k, i]);             
                }
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            double[] buf = new double[MaxOrder];
            DataGridViewCell cell;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    a[k, i] = Convert.ToDouble(cell.Value);
                }
            }

            RunVector(MaxOrder);
           
            tbEigenVal.Text = Convert.ToString(eigenval);
            
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(a[k, i]);

                }
                cell = GSearched[i, 0];
                cell.Value = Convert.ToString(x1[i]);
            }     
        }    
    }
}
