﻿using System;
using System.Windows.Forms;


/*                      Roots of a 4. degree polynomial                             */
/*                              www.mosismath.com                                   */

namespace WindowsFormsApplication1
{
    public struct TKomplex
    {
        public double real;
        public double imag;
    };

    public partial class Mainwin : Form
    {
        TKomplex x1, x2, x3;
        double a, b, c, d;
        double paramA, paramB, paramC, paramD;

        private void groupBox3_Enter(object sender, EventArgs e)
        {

        }

        double u, p, q;
        TKomplex[] res = new TKomplex[4];
        TextBox[] tBroot = new TextBox[4];

        public double Xroot(double a, double x)
        {
            double i = 1;
            if (a < 0)
                i = -1;
            return (i * Math.Exp( Math.Log(a*i)/x));
        }

        public int Calc_Cardano(double dA, double dB, double dC, double dD)  // solve cubic equation according to cardano
        {
            double a, p, q, u, v;
            double r, alpha;
            int res;

            res = 0;
            if (dA != 0)
            {
                a = dB / dA;
                dB = dC / dA;
                dC = dD / dA;

                p = -(a * a / 3.0) + dB;
                q = (2.0 / 27.0 * a * a * a) - (a * dB / 3.0) + dC;
                dD = q * q / 4.0 + p * p * p / 27.0;
                if (Math.Abs(dD) < Math.Pow(10.0, -11.0))
                    dD = 0;
                // 3 cases D > 0, D == 0 and D < 0
                if (dD > 1e-20)
                {
                    u = Xroot(-q / 2.0 + Math.Sqrt(dD), 3.0);
                    v = Xroot(-q / 2.0 - Math.Sqrt(dD), 3.0);
                    x1.real = u + v - a / 3.0;
                    x2.real = -(u + v) / 2.0 - a / 3.0;
                    x2.imag = Math.Sqrt(3.0) / 2.0 * (u - v);
                    x3.real = x2.real;
                    x3.imag = -x2.imag;
                    res = 1;
                }
                if (Math.Abs(dD) <= 1e-20)
                {
                    u = Xroot(-q / 2.0, 3.0);
                    v = Xroot(-q / 2.0, 3.0);
                    x1.real = u + v - a / 3.0;
                    x2.real = -(u + v) / 2.0 - a / 3.0;
                    res = 2;
                }
                if (dD < -1e-20)
                {
                    r = Math.Sqrt(-p * p * p / 27.0);
                    alpha = Math.Atan(Math.Sqrt(-dD) / -q * 2.0);
                    if (q > 0)                         // if q > 0 the angle becomes 2 * PI - alpha
                        alpha = Math.PI + alpha;

                    x1.real = Xroot(r, 3.0) * (Math.Cos((6.0 * Math.PI - alpha) / 3.0) + Math.Cos(alpha / 3.0)) - a / 3.0;
                    x2.real = Xroot(r, 3.0) * (Math.Cos((2.0 * Math.PI + alpha) / 3.0) + Math.Cos((4.0 * Math.PI - alpha) / 3.0)) - a / 3.0;
                    x3.real = Xroot(r, 3.0) * (Math.Cos((4.0 * Math.PI + alpha) / 3.0) + Math.Cos((2.0 * Math.PI - alpha) / 3.0)) - a / 3.0;
                    res = 3;
                }
            }
            else
                res = 0;
            return res;
         }

        private TKomplex CalcQuadrEqu(double a, double b, double c, bool bPlus)
        {
            TKomplex res = new TKomplex();
            res.imag = 0;
            if (bPlus)
            {
                if ((b * b - 4 * a * c) >= 0)
                    res.real = (-b + Math.Sqrt(b * b - 4 * a * c)) / 2.0 / a;
                else
                {
                    res.real = -b / 2.0 / a;
                    res.imag = Math.Sqrt(-b * b + 4 * a * c) / 2.0 / a;
                }
            }
            else
            {
                if ((b * b - 4 * a * c) >= 0)
                    res.real = (-b - Math.Sqrt(b * b - 4 * a * c)) / 2.0 / a;
                else
                {
                    res.real = -b / 2.0 / a;
                    res.imag = -Math.Sqrt(-b * b + 4 * a * c) / 2.0 / a;
                }
            }
            return res;
        }

        public Mainwin()
        {

            InitializeComponent();

            x1 = new TKomplex();
            x2 = new TKomplex();
            x3 = new TKomplex();
            x1.real = 0;
            x1.imag = 0;
            x2.real = 0;
            x2.imag = 0;
            x3.real = 0;
            x3.imag = 0;

            // sample (x-1)*(x+3)*(x+2)*(x+4)
             a = 8.0;
             b = 17.0;
             c = -2.0;
             d = -24.0;

            tb_A.Text = Convert.ToString(a);
            tb_B.Text = Convert.ToString(b);
            tb_C.Text = Convert.ToString(c);
            tb_D.Text = Convert.ToString(d);
            tBroot[0] = tBr1;
            tBroot[1] = tBr2;
            tBroot[2] = tBr3;
            tBroot[3] = tBr4;
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            int i;
            double angle;
            double length;
            bool foundSolution = true;
            TKomplex tempVal;

            tb_x1.Text = "";
            tb_x2.Text = "";
            tb_x3.Text = "";
            tB_u.Text = "";
            tB_p.Text = "";
            tB_q.Text = "";

            if (tb_A.Text != "")
                a = Convert.ToDouble(tb_A.Text);
            else
                a = 0;
            if (tb_B.Text != "")
                b = Convert.ToDouble(tb_B.Text);
            else
                b = 0;
            if (tb_C.Text != "")
                c = Convert.ToDouble(tb_C.Text);
            else
                c = 0;
            if (tb_D.Text != "")
                d = Convert.ToDouble(tb_D.Text);
            else
                d = 0;
            if (8 * c != 4 * a * b - a * a * a)
            {
                //u^3 + 2bu^2 + (-4d + b^2 + ac)u + abc - c^2 - a^2d = 0 
                paramA = 1.0;
                paramB = 2.0 * b;
                paramC = -4.0 * d + b * b + a * c;
                paramD = a * b * c - c * c - a * a * d;

                if ((paramA != 0) && (paramB != 0) && (paramC != 0) && (paramD != 0))
                {
                    switch (Calc_Cardano(paramA, paramB, paramC, paramD))
                    {
                        case 0:
                            {
                                tb_x1.Text = "";
                                tb_x2.Text = "";
                                tb_x3.Text = "";
                                foundSolution = false;
                                break;
                            }
                        case 1:
                            {
                                tb_x1.Text = Convert.ToString(Math.Round(x1.real, 5));
                                tb_x2.Text = "";
                                tb_x3.Text = "";
                                break;
                            }
                        case 2:
                            {
                                tb_x1.Text = Convert.ToString(Math.Round(x1.real, 5));
                                tb_x2.Text = Convert.ToString(Math.Round(x2.real,5));
                                tb_x3.Text = "";
                                break;
                            }
                        case 3:
                            {
                                tb_x1.Text = Convert.ToString(Math.Round(x1.real, 5));
                                tb_x2.Text = Convert.ToString(Math.Round(x2.real, 5));
                                tb_x3.Text = Convert.ToString(Math.Round(x3.real, 5));
                                break;
                            }
                    }
                    if (foundSolution)
                    {
                        u = x1.real;

                        tempVal = CalcQuadrEqu(1, -a, -u, true);
                        p = tempVal.real;
                        q = (p * p * p - a * p * p + b * p - c) / (2 * p - a);

                        res[0] = CalcQuadrEqu(1, p, q, true);
                        res[1] = CalcQuadrEqu(1, p, q, false);
                        res[2] = CalcQuadrEqu(1, (a - p), (b - q - a * p + p * p), true);
                        res[3] = CalcQuadrEqu(1, (a - p), (b - q - a * p + p * p), false);

                        tB_u.Text = Convert.ToString(Math.Round(u, 5));
                        tB_p.Text = Convert.ToString(Math.Round(p, 5));
                        tB_q.Text = Convert.ToString(Math.Round(q, 5));
                    }
                    else
                        MessageBox.Show("No roots found");
                }
            }
            else
            {
                if (a != 0)
                {
                    tB_u.Text = "";
                    p = a / 2.0;
                    q = (c + Math.Sqrt(c * c - a * a * d)) / a;
                    tB_p.Text = Convert.ToString(Math.Round(p, 5));
                    tB_q.Text = Convert.ToString(Math.Round(q, 5));
                    res[0] = CalcQuadrEqu(1, p, q, true);
                    res[1] = CalcQuadrEqu(1, p, q, false);
                    q = (c - Math.Sqrt(c * c - a * a * d)) / a;
                    res[2] = CalcQuadrEqu(1, p, q, true);
                    res[3] = CalcQuadrEqu(1, p, q, false);
                }
                else // if a == 0 => c == 0
                {
                    tempVal = CalcQuadrEqu(1, b, d, true);
                    length = Math.Sqrt(tempVal.real * tempVal.real + tempVal.imag * tempVal.imag);
                    if (tempVal.imag >= 0)
                        angle = Math.Acos(tempVal.real / length) / 2.0;
                    else
                        angle = (2.0 * Math.PI - Math.Acos(tempVal.real / length)) / 2.0;
                    res[0].real = Math.Sqrt(length) * Math.Cos(angle);
                    res[0].imag = Math.Sqrt(length) * Math.Sin(angle);

                    angle += Math.PI;
                    res[1].real = Math.Sqrt(length) * Math.Cos(angle);
                    res[1].imag = Math.Sqrt(length) * Math.Sin(angle);

                    tempVal = CalcQuadrEqu(1, b, d, false);
                    length = Math.Sqrt(tempVal.real * tempVal.real + tempVal.imag * tempVal.imag);
                    if (tempVal.imag >= 0)
                        angle = Math.Acos(tempVal.real / length) / 2.0;
                    else
                        angle = (2.0 * Math.PI - Math.Acos(tempVal.real / length)) / 2.0;
                    res[2].real = Math.Sqrt(length) * Math.Cos(angle);
                    res[2].imag = Math.Sqrt(length) * Math.Sin(angle);

                    angle += Math.PI;
                    res[3].real = Math.Sqrt(length) * Math.Cos(angle);
                    res[3].imag = Math.Sqrt(length) * Math.Sin(angle);

                    tB_p.Text = "----";
                    tB_q.Text = "----";
                }
            }
          
            for(i = 0; i < res.Length; i++)
            {
                if (Math.Abs(res[i].imag) < 1E-6)
                    tBroot[i].Text = Convert.ToString(Math.Round(res[i].real, 5));
                else
                {
                    if (Math.Abs(res[i].real) < 1E-6)
                    {
                        if (res[i].imag > 0)
                            tBroot[i].Text = "j" + Convert.ToString(Math.Round(res[i].imag, 5));
                        else
                            tBroot[i].Text = "-j" + Convert.ToString(Math.Round(-res[i].imag, 5));
                    }
                    else
                    {
                        if (res[i].imag > 0)
                            tBroot[i].Text = Convert.ToString(Math.Round(res[i].real, 5)) + "  j" + Convert.ToString(Math.Round(res[i].imag, 5));
                        else
                            tBroot[i].Text = Convert.ToString(Math.Round(res[i].real, 5)) + " -j" + Convert.ToString(Math.Round(-res[i].imag, 5));
                    }
                }
            }
        }
    }
}
   