﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

/* Integration by Romberg  */
/* www.mosismath.com       */

namespace WindowsFormsApplication1
{
    public struct TKomplex
    {
        public double real;
        public double imag;
    };

    public partial class Mainwin : Form
    {
        const int N = 5;
        double a = 0;
        double b = Math.PI / 2.0;
        double h;
        double[] t = new double[N];
       
        private double f_x(double x)
        {
            return 5.0 / (Math.Exp(Math.PI) - 2.0) * Math.Exp(2 * x) * Math.Cos(x);
        }


        private double CalcRomberg(int N)
        {
            int i, j, k;
            double d;
            h = b - a;
            //trapezoidal rule
            for (j = 1; j <= N; j++)
            {
                t[j - 1] = f_x(a) + f_x(b);
                k = (int)Math.Pow(2, j - 1);
                for (i = 1; i < k; i++)
                {
                    d = f_x(a + h * i);
                    t[j - 1] = t[j - 1] + 2 * d;
                }
                t[j - 1] = t[j - 1] * h / 2;
                h = h / 2;
            }
            // Richardson extrapolation
            for (k = 1; k < N; k++)
            {
                for (i = N - 1; i >= k; i--)
                {
                    t[i] = (Math.Pow(4, k) * t[i] - t[i - 1]) / (Math.Pow(4, k) - 1);
                }
                t[i] = 0; // just for a better visualisation :-)
            }
            return t[N - 1];
        }

        public Mainwin()
        {
            InitializeComponent();
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            tb_M.Text = CalcRomberg(N).ToString();
        }
    }
}
