﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Diagnostics;

/*Integration by the trapezoidal rule*/
/* www.mosismath.com                 */

namespace WindowsFormsApplication1
{
    public struct TKomplex
    {
        public double real;
        public double imag;
    };

    public partial class Mainwin : Form
    {
        const int n = 6;
        double a = 0;
        double b = Math.PI / 2.0;
        double h, k;
        double m;
       
        private double f_x(double x)
        {
            return 5.0 / (Math.Exp(Math.PI) - 2.0) * Math.Exp(2 * x) * Math.Cos(x);
        }
        

        public Mainwin()
        {
            InitializeComponent();
        }

        private double Calcrapezodial(int n)
        {
            int i;
            h = (b - a) / n;
            m = (f_x(a) + f_x(b)) / 2;
            for (i = 1; i < n; i++)
            {
                m = m + f_x(a + h * i);
            }
            m = m * h;
            return m;
        }

        private void bt_Calc_Click(object sender, EventArgs e)
        {
            tb_M.Text = Calcrapezodial(n).ToString();
        }
    }
}
