import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import java.awt.Toolkit;

/*    To solve a matrix equation by Cramer inverse matrix                     */
/*                                 www.mosismath.com                          */

public class mainFrame {
	
int maxOrder = 4;
	
	String[][] matrix	= {
			
			{"0", "0", "-3", "2"},
			{"3", "-5", "4", "-3"},
			{"3", "2", "0", "4"},
			{"5", "-2", "3", "-3"},
	};
	
	String[][] variable	= {
			
			{"-", "-", "-", "-"},
	};
	
	String[][] solution	= {
			
			{"-4.1"},
			{"-2.5"},
			{"14.8"},
			{"4"},
	};
	
	String[] title = {"x1", "x2", "x3", "x4"};
	
	String[] sol = {"y"};
		
	
	double[][] m = new double[maxOrder][maxOrder];
	double[] y = new double[maxOrder];
	double[] x = new double[maxOrder];
	
	TDataGrid matrixData;
	TDataGrid solutionData;
	TDataGrid unknownData;
	
	private void solve()
	{
		String str;
		int i,j;
		for(i=0; i < maxOrder; i++)
		{
			for(j=0; j < maxOrder; j++)
			{
				str = matrixData.getValueAt(i, j).toString();
				m[i][j] = Float.parseFloat(str);
			}
			str = solution[i][0].toString();
			y[i] = Float.parseFloat(str);
		}
		str = "";
		TCramer cramer = new TCramer(maxOrder, m, y);
        cramer.invert();
		
		x = cramer.solve();
		
		for(i=0; i < maxOrder; i++)
		{
			for(j=0; j < maxOrder; j++)
			{
				matrixData.setValueAt(Double.toString(cramer.b[i][j]), i, j);
			}
			solutionData.setValueAt(Double.toString(y[i]), i, 0);
			unknownData.setValueAt(Double.toString(x[i]), 0, i);
		}
	}

	private JFrame frmMatrixFrobenius;
	private JTable tMatrix;
	private JTable tVariable;
	private JTable tSolution;

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					mainFrame window = new mainFrame();
					window.frmMatrixFrobenius.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public mainFrame() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmMatrixFrobenius = new JFrame();
		frmMatrixFrobenius.setIconImage(Toolkit.getDefaultToolkit().getImage(mainFrame.class.getResource("/Ressource/Icon.png")));
		frmMatrixFrobenius.setTitle("MatrixCramer");
		frmMatrixFrobenius.setBounds(100, 100, 527, 218);
		frmMatrixFrobenius.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmMatrixFrobenius.getContentPane().setLayout(null);
		
		matrixData = new TDataGrid(matrix, title, maxOrder, maxOrder);
		tMatrix = new JTable(matrixData);
		tMatrix.setRowHeight(25);
		tMatrix.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		
		tMatrix.setFont(new Font("Tahoma", Font.PLAIN, 14));
		tMatrix.setBounds(10, 11, 390, 120);
		frmMatrixFrobenius.getContentPane().add(tMatrix);
		
		unknownData = new TDataGrid(variable, title, maxOrder, 1);
		tVariable = new JTable(unknownData);
		tVariable.setRowHeight(25);
		tVariable.setFont(new Font("Tahoma", Font.PLAIN, 14));
		tVariable.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		tVariable.setBounds(10, 142, 390, 30);
		frmMatrixFrobenius.getContentPane().add(tVariable);
		
		solutionData = new TDataGrid(solution, sol, 1, maxOrder);
		
		tSolution = new JTable(solutionData);
		tSolution.setRowHeight(25);
		tSolution.setFont(new Font("Tahoma", Font.PLAIN, 14));
		tSolution.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		tSolution.setBounds(410, 11, 89, 118);
		frmMatrixFrobenius.getContentPane().add(tSolution);
		
		JButton btnNewButton = new JButton("calculate");
		btnNewButton.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				solve();
			}
		});
		btnNewButton.setBounds(410, 140, 89, 32);
		frmMatrixFrobenius.getContentPane().add(btnNewButton);
	}

}
