
public class TCramer {
	 public int maxOrder = 4;
     public double[][] m;  // main Matrix
     public double[] y;   // solution vector
     public double[][] b;  // inverse Matrix

     public TCramer(int size, double[][] matrix, double[] solution)
     {
         maxOrder = size;
         m = matrix;
         y = solution;
         b = new double[maxOrder][maxOrder];
     }

     double calcDet(double[][] m, int order)
     {
         int i, j, k;
         double sign = 1.0;
         double dm = 0;
         if (order <= 2)
         {
             return m[0][ 0] * m[1][1] - m[1][0] * m[0][1];
         }
         else
         {
             double[][] mm = new double[order - 1][order - 1]; // temporary matrix
             for (i = 0; i < order; i++) // index for the element of the top row
             {
                 for (j = 0; j < order - 1; j++) // index that runs down from second row to n
                 {
                     for (k = 0; k < order - 1; k++) // index to copy the elements into a sub matrix
                     {
                         if (j < i)
                             mm[j][k] = m[j][k + 1];
                         else
                             mm[j][k] = m[j + 1][k + 1];
                     }
                 }
                 dm = dm + sign * calcDet(mm, order - 1) * m[i][0];
                 sign = -sign;
             }
             return dm;
         }
     }


     public void invert()
     {
         double det = calcDet(m, maxOrder);

         int x, y, j, k;
         double signy = 1.0;
         double signx = 1.0;
         if (det != 0)
         {
             if (maxOrder <= 2)
             {
                 if (maxOrder == 2)
                 {
                     b[0][0] = m[1][1] / det;
                     b[0][1] = -m[0][1] / det;
                     b[1][0] = -m[1][0] / det;
                     b[1][1] = m[0][0] / det;
                 }
             }
             else
             {
                 double[][] mm = new double[maxOrder - 1][maxOrder - 1]; // temporary matrix
                 for (x = 0; x < maxOrder; x++)
                 {
                     signy = 1.0;
                     for (y = 0; y < maxOrder; y++) // index for the element of the top row
                     {
                         for (j = 0; j < maxOrder - 1; j++) // index that runs down from second row to n
                         {
                             for (k = 0; k < maxOrder - 1; k++) // index to copy the elements into a sub matrix
                             {
                                 if (j < y)
                                 {
                                     if (k < x)
                                         mm[j][k] = m[j][k];
                                     else
                                         mm[j][k] = m[j][k + 1];
                                 }
                                 else
                                 {
                                     if (k < x)
                                         mm[j][k] = m[j + 1][k];
                                     else
                                         mm[j][k] = m[j + 1][k + 1];
                                 }
                             }
                         }
                         b[x][y] = signy * signx * calcDet(mm, maxOrder - 1) / det;
                         signy = -signy;
                     }
                     signx = -signx;
                 }
             }
         }
     }

     public double[] solve()
     {
         int k, l;
         double[] x = new double[maxOrder];   
         for (k = 0; k < maxOrder; k++)
         {
             x[k] = 0;
             for (l = 0; l < maxOrder; l++)
             {
                 x[k] = x[k] + y[l] * b[k][l];
             }
         }
         return x;
     }
}
