import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;

import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.border.BevelBorder;
import java.awt.Toolkit;


 /*      Solving a matrix equation by the use of determinants              */
/*                             www.mosismath.com                           */

public class mainFrame {

	private JFrame frmMatrixDeterminant;
	private JTable tMatrix;
	private JTable tVariable;
	private JTable tSolution;
	
    int maxOrder = 4;
	
	String[][] matrix	= {
			
			{"0", "0", "-3", "2"},
			{"3", "-5", "4", "-3"},
			{"3", "2", "0", "4"},
			{"5", "-2", "3", "-3"},
	};
	
	String[][] variable	= {
			
			{"-", "-", "-", "-"},
	};
	
	String[][] solution	= {
			
			{"-4.1"},
			{"-2.5"},
			{"14.8"},
			{"4"},
	};
	
	String[] title = {"x1", "x2", "x3", "x4"};
	
	String[] sol = {"y"};
		
	
	double[][] m = new double[maxOrder][maxOrder];
	double[] y = new double[maxOrder];
	double[] x = new double[maxOrder];
	
	TDataGrid matrixData;
	TDataGrid solutionData;
	TDataGrid unknownData;
	
	double CalcDet(double[][] m, int order)
    {
        int i,j, k;
        double sign = 1.0;
        double dm = 0;
        if (order <= 2)
        {
            return m[0][0] * m[1][1] - m[1][0] * m[0][1]; 
        }
        else
        {
        	double[][] mm = new double[maxOrder-1][maxOrder-1]; // temporary matrix
            for (i = 0; i < order; i++) // index for the element of the top row
            {
                for(j=0; j < order-1; j++) // index that runs down from second row to n
                {
                    for(k=0; k < order-1; k++) // index to copy the elements into a sub matrix
                    {
                        if (j < i)
                            mm[j][k] = m[j][k+1];
                        else
                            mm[j][k] = m[j+1][k+1];
                    }                        
                }
                dm = dm + sign * CalcDet(mm, order - 1) * m[i][0];
                sign = -sign;
            }
            return dm;
        }
    }
	
	private void solve()
	{
		String str;
		int i,j, k;
        double det, detx;
        double[] buf = new double[maxOrder];
        
		for(i=0; i < maxOrder; i++)
		{
			for(j=0; j < maxOrder; j++)
			{
				str = matrixData.getValueAt(i, j).toString();
				m[i][j] = Float.parseFloat(str);
			}
			str = solution[i][0].toString();
			y[i] = Float.parseFloat(str);
		}
		str = "";
		

        det = CalcDet(m, maxOrder);

        for (i = 0; i < maxOrder; i++)
        {
            for (k = 0; k < maxOrder; k++)
            {
                buf[k] = m[k][i];
                m[k][i] = y[k];
            }
            detx = CalcDet(m, maxOrder);
            if (det != 0)
                x[i] = detx / det;
            for (k = 0; k < maxOrder; k++)
            {
                m[k][i] = buf[k];
            }
        }        
		
		for(i=0; i < maxOrder; i++)
		{
			for(j=0; j < maxOrder; j++)
			{
				matrixData.setValueAt(Double.toString(m[i][j]), i, j);
			}
			solutionData.setValueAt(Double.toString(y[i]), i, 0);
			unknownData.setValueAt(Double.toString(x[i]), 0, i);
		}
	}

	/**
	 * Launch the application.
	 */
	public static void main(String[] args) {
		EventQueue.invokeLater(new Runnable() {
			public void run() {
				try {
					mainFrame window = new mainFrame();
					window.frmMatrixDeterminant.setVisible(true);
				} catch (Exception e) {
					e.printStackTrace();
				}
			}
		});
	}

	/**
	 * Create the application.
	 */
	public mainFrame() {
		initialize();
	}

	/**
	 * Initialize the contents of the frame.
	 */
	private void initialize() {
		frmMatrixDeterminant = new JFrame();
		frmMatrixDeterminant.setTitle("Matrix determinant");
		frmMatrixDeterminant.setIconImage(Toolkit.getDefaultToolkit().getImage(mainFrame.class.getResource("/Ressource/Icon.png")));
		frmMatrixDeterminant.setBounds(100, 100, 527, 218);
		frmMatrixDeterminant.setDefaultCloseOperation(JFrame.EXIT_ON_CLOSE);
		frmMatrixDeterminant.getContentPane().setLayout(null);
		
		matrixData = new TDataGrid(matrix, title, maxOrder, maxOrder);
		tMatrix = new JTable(matrixData);
		tMatrix.setRowHeight(25);
		tMatrix.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		
		tMatrix.setFont(new Font("Tahoma", Font.PLAIN, 14));
		tMatrix.setBounds(10, 11, 390, 120);
		frmMatrixDeterminant.getContentPane().add(tMatrix);
		
		unknownData = new TDataGrid(variable, title, maxOrder, 1);
		tVariable = new JTable(unknownData);
		tVariable.setRowHeight(25);
		tVariable.setFont(new Font("Tahoma", Font.PLAIN, 14));
		tVariable.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		tVariable.setBounds(10, 142, 390, 30);
		frmMatrixDeterminant.getContentPane().add(tVariable);
		
		solutionData = new TDataGrid(solution, sol, 1, maxOrder);
		
		tSolution = new JTable(solutionData);
		tSolution.setRowHeight(25);
		tSolution.setFont(new Font("Tahoma", Font.PLAIN, 14));
		tSolution.setBorder(new BevelBorder(BevelBorder.LOWERED, null, null, null, null));
		tSolution.setBounds(410, 11, 89, 118);
		frmMatrixDeterminant.getContentPane().add(tSolution);
		
		JButton btnNewButton = new JButton("calculate");
		btnNewButton.addMouseListener(new MouseAdapter() {
			@Override
			public void mouseClicked(MouseEvent e) {
				solve();
			}
		});
		btnNewButton.setBounds(410, 140, 89, 32);
		frmMatrixDeterminant.getContentPane().add(btnNewButton);
	}

}
