﻿	function Errorhandling(error, file, row)
    {
      alert("Error: " + error + "\nFile: " + file + "\nRow: " + row);
    }
	
	var order = 2;
	
	var datapoints = 1000;
    var a_z = new Array(order+1);
	var b_z = new Array(1);
	var a_s = new Array(1);
    var x = new Array(order);
    var y = new Array(order); 
	var t_in = new Array(datapoints);
    var y_in = new Array(datapoints);
	var y_out = new Array(datapoints);
	var f = 40.0;
    var fs = 10000.0;
    var fc = 500.0;
	var tc = 1.0;
	
	
	function MultPoly(p1, p2)
    {
        var i;
		var j;
        var tempPoly = new Array(p1.length + p2.length - 1);
		tempPoly.fill(0);
        for (i = 0; i < p1.length; i++)
        {
            for (j = 0; j < p2.length; j++)
            {
                tempPoly[j + i] = tempPoly[j + i] + p2[j] * p1[i];
            }
        }
        return tempPoly;
    }
	
	
	function Mult(p1, p2)
    {
        var i;
        for (i = 0; i < p1.length; i++)
        {
            p1[i] = p1[i] * p2;
        }
        return p1;
    }


    function Power(a, power)
    {
		var i;
        var  a2 = new Array(1)
	    a2[0] = 1.0;
        for (i = 0; i < power; i++)
            a2 = MultPoly(a2, a);
        return a2;
    }


	function CalcButterworth(order)
    {
        var i = 1;
        var poly =  new Array(3);
        var poly2 = new Array(2);
        poly[0] = 1.0;

        if (order % 2 == 0)
        {
            poly[2] = 1.0;
            for (i = 1; i <= order / 2; i++)
            {
                poly[1] = 2.0 * Math.cos((2 * i - 1) * Math.PI / 2 / order);
                a_s = MultPoly(a_s, poly);
            }
        }
        else
        {
            poly2[0] = 1.0;
            poly2[1] = 1.0;
            a_s = MultPoly(a_s, poly2);
            poly[2] = 1.0;
            for (i = 2; i <= (order + 1) / 2; i++)
            {
                poly[1] = 2.0 * Math.cos((i - 1) * Math.PI / order);
                a_s = MultPoly(a_s, poly);
            }
        }
    }

      
    function TransformToZPlane(bHighPass)
    {
        var i;
		var j;
        var tempA = new Array(2);
        var aa = new Array(order+1);
        for (i = 0; i <= order; i++)
        {
            aa[i] = new Array(2);
			aa[i][0] = 1;
			aa[i][1] = -1;
        }
        tempA[0] = 1;
        if (bHighPass)
        {
            tempA[1] = -1;
            b_z = Power(tempA, order);
            b_z = Mult(b_z, Math.pow(2.0 / tc, order));
        }
        else
        {
            tempA[1] = 1;
            b_z = Power(tempA, order);
        }
        tempA[1] = 1;
        for (i = 0; i <= order; i++)
        {
            aa[i] = MultPoly(Power(tempA, i), Power(aa[i], order - i));
            aa[i] = Mult(aa[i], a_s[i] * Math.pow(2.0 / tc, order - i));
        }
        for (i = 0; i <= order; i++)
        {
            a_z[i] = 0;
            for (j = 0; j <= order; j++)
            a_z[i] = a_z[i] + aa[j][i];
        }
        for (i =0; i < b_z.length; i++)
        {
            b_z[i] = b_z[i] / a_z[0];
        }
        for (i = order; i >= 0; i--)
        {
            a_z[i] = a_z[i] / a_z[0];
        }       
    }


    function calculate()
    {  
		const cbHighPass = document.getElementById('cbHighPass');
		a_z = new Array(order+1);
	    b_z = new Array(1);
	    a_s = new Array(1);
        a_s[0] =  1.0;
		tc = 2.0 * Math.PI * fc / fs;
		CalcButterworth(order);
		TransformToZPlane(cbHighPass.checked);
		for (i = 0; i < datapoints; i++)
        {
            t_in[i] = i / fs;
            y_in[i] = 20.0 * Math.sin(2.0 * Math.PI * t_in[i] * f);
        }
		try
		{
			 for (i = 0; i <= order; i++)
            {
                y_out[i] = 0;
                for (j = 0; j <= i; j++)
                {
                    y_out[i] = y_out[i] + y_in[i-j] * b_z[j];
                }
                for (j = 1; j <= i; j++)
                {
                    y_out[i] = y_out[i] - y_out[i-j] * a_z[j];
                }
            }

            for (i = order + 1; i < datapoints; i++)
            {
                y_out[i] = 0;
                for (j = 0; j <= order; j++)
                {
                    y_out[i] = y_out[i] + y_in[i - j] * b_z[j];
                }
                for (j = 1; j <= order; j++)
                {
                    y_out[i] = y_out[i] - y_out[i - j] * a_z[j];
                }
            }
			drawGraph(datapoints, t_in[0], t_in[datapoints - 1]);
			for(var i=0; i <= order; i++)
			{
				document.getElementById("B" + (i+1)).value = b_z[i].toFixed(5);  
				document.getElementById("A" + (i+1)).value = a_z[i].toFixed(5);  
			}
		}
		catch(er)
		{
			alert(er);
		}
	}


    function createInput(order, knot)
    {
		knotName = knot;
		actKnot = document.getElementById(knot);
		var  tableRow = document.createElement("p");
		actKnot.appendChild(tableRow);
		var text = document.createTextNode(" b : ");
	    tableRow.appendChild(text);
		for (var i = 1; i <= order+1; i++)
		{
			var res = document.createElement("input");
			res.setAttribute("id","B" + i);
			res.setAttribute("style","width:80px");
			tableRow.appendChild(res);
		}
		var  tableRow = document.createElement("p");
		actKnot.appendChild(tableRow);
		var text = document.createTextNode(" a : ");
	    tableRow.appendChild(text);
		for (var i = 1; i <= order+1; i++)
		{
			var res = document.createElement("input");
			res.setAttribute("id","A" + i);
			res.setAttribute("style","width:80px");
			tableRow.appendChild(res);
		}
	}
	
	function drawGraph(maxPoints, minX, maxX)
	{
		var i,j;
        var maxVal = -1.0;
        var minVal = 1.0;
		var xRange;
        var scalefactor;
        var drawCeroline;
		var graphHeight;
		var graphWidth;
		var p1X, p1Y;
		var p2X, p2Y;
		let cx = document.querySelector("canvas").getContext("2d");
		cx.beginPath();
		graphHeight = cx.canvas.height;
		graphWidth = cx.canvas.width;
		cx.clearRect(0, 0, graphWidth, graphHeight);
		for (j = 0; j < maxPoints - 1; j++)
        {
            //if ((xp[j] >= minX) && (xp[j] <= maxX))
            {
                if (maxVal < y_in[j])
                    maxVal = y_in[j];
                if (minVal > y_in[j])
                    minVal = y_in[j];
            }
        }
		xRange = (maxX - minX) * 1.05;
		if (minVal < 0)
        {
            if (maxVal > 0)
            {
                if (maxVal > Math.abs(minVal))
                    scalefactor = graphHeight / maxVal / 2.2;
                else
                    scalefactor = graphHeight / Math.abs(minVal) / 2.2;
            }
            else
                scalefactor = 5.0;
            drawCeroline = true;
        }
        else
        {
            scalefactor = graphHeight / (maxVal) / 1.1;
            drawCeroline = false;
        }
		if (drawCeroline)
        {
			cx.moveTo(0, graphHeight / 2);
			cx.lineTo(graphWidth, graphHeight / 2);
			cx.strokeStyle='black';
			cx.stroke();
			cx.beginPath();
        }
		
		if (maxX > 0) // draw interpolated graph
        {
			cx.beginPath();
            for (j = 0; j < maxPoints - 1; j++)
            {
                if ((t_in[j] >= minX) && (t_in[j] <= maxX))
                {
                    p1X = (t_in[j] - minX) * graphWidth / xRange + 20;
                    p2X = (t_in[j + 1] - minX) * graphWidth / xRange + 20;
                    if (drawCeroline)
                    {
                        p1Y = (graphHeight / 2) - y_in[j] * scalefactor;
                        p2Y = (graphHeight / 2) - y_in[j + 1] * scalefactor;
                    }
                    else
                    {
                        p1Y = (graphHeight) - y_in[j] * scalefactor;
                        p2Y = (graphHeight) - y_in[j + 1] * scalefactor;
                    }
                    cx.moveTo(Math.round(p1X), Math.round(p1Y));
			    	cx.lineTo(Math.round(p2X), Math.round(p2Y));
                }
            }
			cx.strokeStyle='magenta';
			cx.stroke();
			
			cx.beginPath();
			for (j = 0; j < maxPoints - 1; j++)
            {
                if ((t_in[j] >= minX) && (t_in[j] <= maxX))
                {
                    p1X = (t_in[j] - minX) * graphWidth / xRange + 20;
                    p2X = (t_in[j + 1] - minX) * graphWidth / xRange + 20;
                    if (drawCeroline)
                    {
                        p1Y = (graphHeight / 2) - y_out[j] * scalefactor;
                        p2Y = (graphHeight / 2) - y_out[j + 1] * scalefactor;
                    }
                    else
                    {
                        p1Y = (graphHeight) - y_out[j] * scalefactor;
                        p2Y = (graphHeight) - y_out[j + 1] * scalefactor;
                    }
                    cx.moveTo(Math.round(p1X), Math.round(p1Y));
			    	cx.lineTo(Math.round(p2X), Math.round(p2Y));
                }
            }
			cx.strokeStyle='blue';
			cx.stroke();
        }
		
	}
 
	function selectOrder()
	{
		const input = document.getElementById('idOrder');
		order =  parseInt(input.value)
		a_z = new Array(order+1);
	    b_z = new Array(1);
	    a_s = new Array(1);
		for(var i = actKnot.childNodes.length - 1; i >= 0; i--)
		{
		   var el = actKnot.childNodes[i];
		   actKnot.removeChild(el);
		}
		createInput(order, knotName);
	}
	
	function setFequency()
	{
		var tempFc;
		var tempFs;
		var tempF;
		
		try
		{
			const iFc = document.getElementById('efCutoff');
			if(iFc.value != "")
				tempFc = parseInt(iFc.value);
			
			const iFs = document.getElementById('efSample');
			if(iFs.value != "")
				tempFs = parseInt(iFs.value);
			
			const iFt = document.getElementById('efTest');
			if(iFt.value != "")
				tempF = parseInt(iFt.value);
			
			if(tempFs < 0)
			{
				alert("The sample frequency must be > 0!");
			}
			else
			{
				if(tempFc < 0)
				{
					alert("The cut off frequency must be > 0!");
				}
				else
				{
					if(tempFc >  tempFs)
					{
						alert("The cut off frequency must be < sample frequency!");
					}
					else
					{
						if(!isNaN(tempFs))
							fs = tempFs;
						if(!isNaN(tempFc))
							fc = tempFc;
					}
				}
			}
			if(tempF < 0)
			{
				alert("The test frequency must be > 0!");
			}
			else
			{
				if(!isNaN(tempF))
					f = tempF
			}
			iFs.value = fs.toFixed(0);  
			iFc.value = fc.toFixed(0);  
			iFt.value = f.toFixed(0);  
		}
		catch(er)
		{
			alert(er);
		}
	}
	