﻿
using System;
using System.Windows.Forms;

/* To solve a matrix (symmetric) equation by Cholesky decomposition */
/*                       www.mosismath.com                          */

namespace WindowsFormsApplication1
{

     public partial class MainWin : Form
    {
        public int MaxOrder = 4;
        double[,] a;
        double[] d;
        double[,] l;
        double[] y;
        double[] x;
      

        private bool Cholesky_decomp()
        {
            int i, j, k;
            bool result = true;
      
            for (i = 0; i < MaxOrder; i++)
            {
                for (j = 0; j <= i; j++)
                {
                    if (i > j)
                    {
                        l[i, j] = a[i, j];
                        for (k = 0; k < j; k++)
                            l[i, j] = l[i, j] - l[i, k] * l[j, k];

                        if (Math.Abs(l[j, j]) > 1E-200)
                            l[i, j] = l[i, j] / l[j, j];
                        else
                            result = false;
                    }
                    if (i == j)
                    {
                        l[i, i] = a[i, i];
                        for (k = 0; k < j; k++)
                        {
                            l[i, i] = l[i, i] - (l[i, k] * l[i, k]);
                        }
                        if (l[i, i] >= 0)
                            l[i, i] = Math.Sqrt(l[i, i]);
                        else
                            result = false;
                    }
                }
            }
            return result;
        }

        bool Solve()
        {
            bool result = true;
            int i, j;
            for (j = 0; j < MaxOrder; j++)
            {
                y[j] = d[j];
                for (i = 0; i < j; i++)
                {
                    y[j] = y[j] - y[i] * l[j, i];
                }
                if (Math.Abs(l[j, j]) > 1E-200)
                    y[j] = y[j] / l[j, j];
                else
                    result = false;
            }
            x[MaxOrder - 1] = y[MaxOrder - 1] / l[MaxOrder - 1, MaxOrder - 1];

            for (j = MaxOrder - 2; j >= 0; j--)
            {
                x[j] = y[j];
                for (i = MaxOrder - 1; i > j; i--)
                {
                    x[j] = x[j] - x[i] * l[i, j];
                }
                if (Math.Abs(l[j, j]) > 1E-200)
                    x[j] = x[j] / l[j, j];
                else
                    result = false;
            }
            return result;
        }


 
        public MainWin()
        {
            int i, k;
            a = new double[MaxOrder, MaxOrder]; // equation Matrix
            d = new double[MaxOrder];
            l = new double[MaxOrder, MaxOrder]; // lower diagonal Matrix
            x = new double[MaxOrder];
            y = new double[MaxOrder];
            DataGridViewCell cell;

            InitializeComponent();

            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
            GVectorY.RowCount = MaxOrder;
            GVectorY.ColumnCount = 1;
            GVectorX.RowCount = 1;
            GVectorX.ColumnCount = MaxOrder;
 
            a[0, 0] = 10.0;
            a[0, 1] = 3.0;
            a[0, 2] = 2.0;
            a[0, 3] = 4.0;

            d[0] = 30.4;

            a[1, 0] = 3.0;
            a[1, 1] = 11.0;
            a[1, 2] = 1.0;
            a[1, 3] = 2.0;

            d[1] = 33.7;

            a[2, 0] = 2.0;
            a[2, 1] = 1.0;
            a[2, 2] = 8.0;
            a[2, 3] = 3.0;

            d[2] = 29.7;

            a[3, 0] = 4.0;
            a[3, 1] = 2.0;
            a[3, 2] = 3.0;
            a[3, 3] = 9.0;

            d[3] = 32.0;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(a[k, i]);
                }
                cell = GVectorY[0, i];
                cell.Value = Convert.ToString(d[i]);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            double[] buf = new double[MaxOrder];

            DataGridViewCell cell;


            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    a[k, i] = Convert.ToDouble(cell.Value);

                }
                cell = GVectorY[0, i];  // get cell to access
                d[i] = Convert.ToDouble(cell.Value);
            }

            if (Cholesky_decomp())
            {
                if (Solve())
                {
                    for (i = 0; i < MaxOrder; i++)
                    {
                        cell = GVectorX[i, 0];
                        cell.Value = Convert.ToString(x[i]);
                    }
                }
                else
                    MessageBox.Show("Calculatrion error");
            }
            else
                MessageBox.Show("Calculatrion error");
        } 
    }
}
