﻿namespace WindowsFormsApplication1
{
    class Gaussian
    {
        public int maxOrder = 4;
        Matrix ml;

        void SwitchRows(int n)
        {
            TComplex tempD;
            int i, j;
            for (i = n; i <= maxOrder - 2; i++)
            {
                for (j = 0; j <= maxOrder - 1; j++)
                {
                    tempD = ml.a[i, j];
                    ml.a[i, j] = ml.a[i + 1, j];
                    ml.a[i + 1, j] = tempD;
                }
                tempD = ml.y[i];
                ml.y[i] = ml.y[i + 1];
                ml.y[i + 1] = tempD;
            }
        }


        public Gaussian(int size, Matrix mi)
        {
            maxOrder = size;
            ml = mi;
        }

        public bool Eliminate()
        {
            int i, k, l;
            bool calcError = false;
            i = 1;

            for (k = 0; k <= maxOrder - 2; k++)
            {
                l = k + 1;
                while ((Complex.Abs(ml.a[k, k]) < 1e-8) && (l < maxOrder))
                {
                    SwitchRows(k);
                    l++;
                }
                if (l < maxOrder)
                {
                    for (i = k; i <= maxOrder - 2; i++)
                    {
                        if (!calcError)
                        {
                            if (Complex.Abs(ml.a[i + 1, k]) > 1e-8)
                            {
                                for (l = k + 1; l <= maxOrder - 1; l++)
                                {
                                    ml.a[i + 1, l] = Complex.Diff(Complex.Prod(ml.a[i + 1, l], ml.a[k, k]), Complex.Prod(ml.a[k, l], ml.a[i + 1, k]));
                                }
                                ml.y[i + 1] = Complex.Diff(Complex.Prod(ml.y[i + 1], ml.a[k, k]), Complex.Prod(ml.y[k], ml.a[i + 1, k]));
                                ml.a[i + 1, k].real = 0.0;
                                ml.a[i + 1, k].imag = 0.0;
                            }

                        }
                    }
                }
                else
                    calcError = true;
            }
            return !calcError;
        }

        public void Solve()
        {
            int k, l;

            for (k = maxOrder - 1; k >= 0; k--)
            {
                for (l = maxOrder - 1; l >= k; l--)
                {
                    ml.y[k] = Complex.Diff(ml.y[k], Complex.Prod(ml.x[l], ml.a[k, l]));
                }
                ml.x[k] = Complex.Quot(ml.y[k], ml.a[k, k]);
            }
        }
    }
}
