﻿
using System;
using System.Windows.Forms;

/*                       Gaussian elimination algorithm complex                        */
/*                                 www.mosismath.com                                   */


namespace WindowsFormsApplication1
{
   
    public partial class MainWin : Form
    {
        public int MaxOrder = 6;
        public TComplex EigenVal; 
        Matrix m;
        Gaussian gauss;

        public MainWin()
        {
            int i, k;
            DataGridViewCell cell;
            m = new Matrix(MaxOrder);
            gauss = new Gaussian(MaxOrder, m);

            InitializeComponent();

            EigenVal.real = 5.0;
            EigenVal.imag = -6.0;
           
            GMatrixA.ColumnCount  = MaxOrder;
            GMatrixA.RowCount     = MaxOrder;
            GSolution.ColumnCount = 1;
            GSolution.RowCount    = MaxOrder;
            GSearched.ColumnCount = MaxOrder;
            GSearched.RowCount = 2;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    m.a[0, 0].imag = 0.0;

                }
                m.y[i].imag = 0.0;
            }

            m.a[0, 0].real = 7.0;
            m.a[0, 1].real = 3.0;
            m.a[0, 2].real = 4.0;
            m.a[0, 3].real = -11.0;
            m.a[0, 4].real = -9.0;
            m.a[0, 5].real = -2.0;

            m.a[1, 0].real = -6.0;
            m.a[1, 1].real = 4.0;
            m.a[1, 2].real = -5.0;
            m.a[1, 3].real = 7.0;
            m.a[1, 4].real = 1.0;
            m.a[1, 5].real = 12.0;

            m.a[2, 0].real = -1.0;
            m.a[2, 1].real = -9.0;
            m.a[2, 2].real = 2.0;
            m.a[2, 3].real = 2.0;
            m.a[2, 4].real = 9.0;
            m.a[2, 5].real = 1.0;

            m.a[3, 0].real = -8.0;
            m.a[3, 1].real = 0.0;
            m.a[3, 2].real = -1.0;
            m.a[3, 3].real = 5.0;
            m.a[3, 4].real = 0.0;
            m.a[3, 5].real = 8.0;

            m.a[4, 0].real = -4.0;
            m.a[4, 1].real = 3.0;
            m.a[4, 2].real = -5.0;
            m.a[4, 3].real = 7.0;
            m.a[4, 4].real = 2.0;
            m.a[4, 5].real = 10.0;

            m.a[5, 0].real = 6.0;
            m.a[5, 1].real = 1.0;
            m.a[5, 2].real = 4.0;
            m.a[5, 3].real = -11.0;
            m.a[5, 4].real = -7.0;
            m.a[5, 5].real = -1.0;


            m.y[0].real = 1.0;
            m.y[1].real = 1.0;
            m.y[2].real = 1.0;
            m.y[3].real = 1.0;
            m.y[4].real = 1.0;
            m.y[5].real = 1.0;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m.a[k, i].real);

                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(m.y[i].real);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            DataGridViewCell cell;
         
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    m.a[k, i].real = Convert.ToDouble(cell.Value);

                }
                cell = GSolution[0, i];
                m.y[i].real = Convert.ToDouble(cell.Value);
            }

            if (gauss.Eliminate())
            {
                for (i = 0; i < MaxOrder; i++)
                {
                    for (k = 0; k < MaxOrder; k++)
                    {
                        cell = GMatrixA[k, i];  // get cell to access
                        cell.Value = Convert.ToString(m.a[i, k].real);
                    }
                    cell = GSolution[0, i];
                    cell.Value = Convert.ToString(m.y[i].real);
                }
                gauss.Solve();
                for (i = 0; i < MaxOrder; i++)
                {
                    cell = GSearched[i, 0];
                    cell.Value = Convert.ToString(m.x[i].real);
                    cell = GSearched[i, 1];
                    cell.Value = Convert.ToString(m.x[i].imag);
                }
            }
            else
                MessageBox.Show("Calculation error");
        }    
    }
}
