﻿
using System;
using System.Windows.Forms;

/*    To solve a matrix equation by Householder transformations   */
/*               www.mosismath.com                                */

namespace WindowsFormsApplication1
{

     public partial class MainWin : Form
    {
        public int MaxOrder = 4;
     
        TMatrix r;

        public class TMatrix
        {
            public int size;
            public double[,] c;  // main Matrix
            public double[] d;   // solution vector
            public double[] x;   // vector of the unknowns

            public TMatrix(int sizeM)
            {
                size = sizeM;
                c = new double[size, size]; 
                d = new double[size];
                x = new double[size]; 
            }

            public void MultMatrix(TMatrix m1)
            {
                int i, j, k;
                double[,] al = new double[size, size];
                double[] yl = new double[size];
                for (i = 0; i < size; i++)
                {
                    yl[i] = 0.0;
                    for (j = 0; j < size; j++)
                    {
                        yl[i] = yl[i] + (d[j] * m1.c[i, j]);
                        al[i, j] = 0.0;
                        for (k = 0; k < size; k++)
                        {
                            al[i, j] = al[i, j] + (c[k, j] * m1.c[i, k]);
                        }
                    }
                }
                for (i = 0; i < size; i++)
                {
                    d[i] = yl[i];
                    for (j = 0; j < size; j++)
                    {
                        c[i, j] = al[i, j];
                    }
                }
            }
        }


        public void RunHouseholder(int samples, int col)
        {
            int i, j;
            double lamda = 0;
            double beta;
            double[] w = new double[samples];
            double[,] I = new double[samples, samples];

            // calc parameters
            for (i = col; i < samples; i++)
            {
                lamda = lamda + m.c[i, col] * m.c[i, col];
            }
            lamda = Math.Sqrt(lamda);
            if (m.c[col, col] < 0)
                lamda = -lamda;
            beta = Math.Sqrt(2 * lamda * (lamda + m.c[col, col]));
            w[col] = (lamda + m.c[col, col]) / beta;
            for (i = col + 1; i < samples; i++)
                w[i] = m.c[i, col] / beta;
            //calc matrix parameters
            for (i = 0; i < samples; i++) // unit matrix
            {
                for (j = 0; j < samples; j++)
                {
                    I[i, j] = 0.0;
                }
                I[i, i] = 1.0;
            }
            for (i = 0; i < samples; i++)
            {
                if (i >= col)
                {
                    for (j = 0; j < samples; j++)
                    {
                        if (j >= col)
                            r.c[i, j] = I[i, j] - 2 * w[i] * w[j];
                        else
                            r.c[i, j] = I[i, j];
                    }
                }
                else
                {
                    for (j = 0; j < samples; j++)
                        r.c[i, j] = I[i, j];
                }
            }
            m.MultMatrix(r);
        }  

        public void SolveRMatrix(int maxOrder, TMatrix mi)
        {
            int k, l;
            for (k = maxOrder - 1; k >= 0; k--)
            {
                for (l = maxOrder - 1; l > k; l--)
                {
                    mi.d[k] = mi.d[k] - mi.x[l] * mi.c[k, l];
                }
                if (mi.c[k, k] != 0)
                    mi.x[k] = mi.d[k] / mi.c[k, k];
                else
                    mi.x[k] = 0;
            }
        }

        TMatrix m;

        public MainWin()
        {
            int i, k;
            m = new TMatrix(MaxOrder); // equation Matrix
            r = new TMatrix(MaxOrder); // rotation Matrix
            DataGridViewCell cell;

            InitializeComponent();

            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
            for (i = 0; i < GMatrixA.ColumnCount; i++)
                GMatrixA.Columns[i].Width = 160;
            GSolution.ColumnCount = 1;
            GSolution.Columns[0].Width = 70;
            GSolution.RowCount = MaxOrder;
            GUnknowns.ColumnCount = MaxOrder;
            GUnknowns.RowCount = 2;

            m.c[0, 0] = 3.0;
            m.c[0, 1] = -5.0;
            m.c[0, 2] = 4.0;
            m.c[0, 3] = -3.0;

            m.d[0] = -2.5;

            m.c[1, 0] = 3.0;
            m.c[1, 1] = 2.0;
            m.c[1, 2] = 0.0;
            m.c[1, 3] = 4.0;

            m.d[1] = 14.8;

            m.c[2, 0] = 5.0;
            m.c[2, 1] = -2.0;
            m.c[2, 2] = 3.0;
            m.c[2, 3] = -3.0;

            m.d[2] = 4.0;

            m.c[3, 0] = 0.0;
            m.c[3, 1] = 0.0;
            m.c[3, 2] = -3.0;
            m.c[3, 3] = 2.0;

            m.d[3] = -4.1;
                       
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m.c[k, i]);
                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(m.d[i]);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            double[] buf = new double[MaxOrder];
            TMatrix a = new TMatrix(MaxOrder);
            DataGridViewCell cell;
           
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    m.c[k, i] = Convert.ToDouble(cell.Value);
                }
                cell = GSolution[0, i];
                m.d[i] = Convert.ToDouble(cell.Value);
            }

            for (i = 0; i < MaxOrder-1; i++)
                RunHouseholder(MaxOrder, i);

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m.c[k, i]);

                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(m.d[i]);
            }

            SolveRMatrix(MaxOrder, m);
          
            for (i = 0; i < MaxOrder; i++)
            {
                cell = GUnknowns[i, 0];
                cell.Value = Convert.ToString(m.x[i]);
            }
            
        }
    }
}
