﻿
using System;
using System.Windows.Forms;

/*  To solve a matrix equaiton by the use of the inverse matrix of Cramer  */
/*                             www.mosismath.com                           */


namespace WindowsFormsApplication1
{

     public partial class MainWin : Form
    {
        public int MaxOrder = 4;
        public double[,] a;  // main Matrix
        public double[] d;   // solution vector
        public double[] x;   // vector of the unknowns
        public double[,] b;  // inverse Matrix
       
        double CalcDet (double[,] m, int order)
        {
            int i,j, k;
            double sign = 1.0;
            double dm = 0;
            if (order <= 2)
            {
                return m[0, 0] * m[1, 1] - m[1, 0] * m[0, 1]; 
            }
            else
            {
                double[,] mm = new double[order - 1, order - 1]; // temporary matrix
                for (i = 0; i < order; i++) // index for the element of the top row
                {
                    for(j=0; j < order-1; j++) // index that runs down from second row to n
                    {
                        for(k=0; k < order-1; k++) // index to copy the elements into a sub matrix
                        {
                            if (j < i)
                                mm[j,k] = m[j, k+1];
                            else
                                mm[j,k] = m[j+1, k+1];
                        }                        
                    }
                    dm = dm + sign * CalcDet(mm, order - 1) * m[i, 0];
                    sign = -sign;
                }
                return dm;
            }
        }


        void invert()
        {
            double det = CalcDet(a, MaxOrder);

            int x, y, j, k;
            double signy = 1.0;
            double signx = 1.0;
            if (det != 0)
            {
                if (MaxOrder <= 2)
                {
                    if (MaxOrder == 2)
                    {
                        b[0, 0] = a[1, 1] / det;
                        b[0, 1] = -a[0, 1] / det;
                        b[1, 0] = -a[1, 0] / det;
                        b[1, 1] = a[0, 0] / det;
                    }
                }
                else
                {
                    double[,] mm = new double[MaxOrder - 1, MaxOrder - 1]; // temporary matrix
                    for (x = 0; x < MaxOrder; x++)
                    {
                        signy = 1.0;
                        for (y = 0; y < MaxOrder; y++) // index for the element of the top row
                        {
                            for (j = 0; j < MaxOrder - 1; j++) // index that runs down from second row to n
                            {
                                for (k = 0; k < MaxOrder - 1; k++) // index to copy the elements into a sub matrix
                                {
                                    if (j < y)
                                    {
                                        if (k < x)
                                            mm[j, k] = a[j, k];
                                        else
                                            mm[j, k] = a[j, k + 1];
                                    }
                                    else
                                    {
                                        if (k < x)
                                            mm[j, k] = a[j + 1, k];
                                        else
                                            mm[j, k] = a[j + 1, k + 1];
                                    }
                                }
                            }
                            b[x, y] = signy * signx * CalcDet(mm, MaxOrder - 1) / det;
                            signy = -signy;
                        }
                        signx = -signx;
                    }
                }
            }
        }

        public void Solve()
        {
            int k, l;
            for (k = 0; k < MaxOrder; k++)
            {
                x[k] = 0;
                for (l = 0; l < MaxOrder; l++)
                {
                    x[k] = x[k] + d[l] * b[k, l];
                }

            }
        }

        public MainWin()
        {
            int i, k;
            a = new double[MaxOrder, MaxOrder];
            x = new double[MaxOrder];
            d = new double[MaxOrder];
            b = new double[MaxOrder, MaxOrder];
            DataGridViewCell cell;

            InitializeComponent();

            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
            for (i = 0; i < GMatrixA.ColumnCount; i++)
                GMatrixA.Columns[i].Width = 160;
            GSolution.ColumnCount = 1;
            GSolution.Columns[0].Width = 70;
            GSolution.RowCount = MaxOrder;
            GUnknowns.ColumnCount = MaxOrder;
            GUnknowns.RowCount = 2;

            a[0, 0] = 3.0;
            a[0, 1] = -5.0;
            a[0, 2] = 4.0;
            a[0, 3] = -3.0;

            d[0] = -2.5;

            a[1, 0] = 3.0;
            a[1, 1] = 2.0;
            a[1, 2] = 0.0;
            a[1, 3] = 4.0;

            d[1] = 14.8;

            a[2, 0] = 5.0;
            a[2, 1] = -2.0;
            a[2, 2] = 3.0;
            a[2, 3] = -3.0;

            d[2] = 4.0;

            a[3, 0] = 0.0;
            a[3, 1] = 0.0;
            a[3, 2] = -3.0;
            a[3, 3] = 2.0;

            d[3] = -4.1;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(a[k, i]);
                    //u.c[k, i] = m.c[k, i];

                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(d[i]);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            double[] buf = new double[MaxOrder];
            DataGridViewCell cell;
            
            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    a[k, i] = Convert.ToDouble(cell.Value);
                }
                cell = GSolution[0, i];
                d[i] = Convert.ToDouble(cell.Value);
            }

            invert();

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(b[k, i]);

                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(d[i]);
            }
            Solve();
           
            for (i = 0; i < MaxOrder; i++)
            {
                cell = GUnknowns[i, 0];
                cell.Value = Convert.ToString(x[i]);
            }
        }    
    }
}
