﻿
using System;
using System.Windows.Forms;

/*    Solving a matrix equation by the use of the inverse matrix  */
/*                        www.mosismath.com                       */

namespace WindowsFormsApplication1
{

    public partial class MainWin : Form
    {
        public int MaxOrder = 4;

        public TextBox[,] tbm;
        public TextBox[] tbs;
        public TextBox[] tbx;

        double[,] inv;
        double[,] m;
        double[] y;
        double[] x;


        void SwitchRows(int n)
        {
            double tempD;
            int i, j;
            for (i = n; i <= MaxOrder - 2; i++)
            {
                for (j = 0; j <= MaxOrder - 1; j++)
                {
                    tempD = m[i, j];
                    m[i, j] = m[i + 1, j];
                    m[i + 1, j] = tempD;
                }
                tempD = y[i];
                y[i] = y[i + 1];
                y[i + 1] = tempD;
            }
        }


        public bool CalcInverse()
        {
            int i, k, l;
            bool calcError = false;
            double tempEl;
            i = 1;

            for (k = 0; k <= MaxOrder - 2; k++)
            {
                if (Math.Abs(m[k, k]) > 1e-8)
                {
                    for (i = k; i <= MaxOrder - 2; i++)
                    {
                        if (!calcError)
                        {
                            if (Math.Abs(m[i + 1, k]) > 1e-8)
                            {
                                tempEl = m[i + 1, k];
                                for (l = 0; l <= MaxOrder - 1; l++)
                                {
                                    if (l >= k)
                                        m[i + 1, l] = m[i + 1, l] * m[k, k] - m[k, l] * tempEl;
                                    inv[i + 1, l] = inv[i + 1, l] * m[k, k] - inv[k, l] * tempEl;
                                }
                            }
                        }
                    }

                    if (Math.Abs(m[MaxOrder - 1 - k, MaxOrder - 1 - k]) > 1e-8)
                    {
                        for (i = k; i <= MaxOrder - 2; i++)
                        {
                            if (!calcError)
                            {
                                if (Math.Abs(m[MaxOrder - i - 2, MaxOrder - 1 - k]) > 1e-8)
                                {
                                    tempEl = m[MaxOrder - i - 2, MaxOrder - k - 1];
                                    for (l = MaxOrder - 1; l >= 0; l--)
                                    {
                                        if (l <= MaxOrder - k - 1)
                                            m[MaxOrder - i - 2, l] = m[MaxOrder - i - 2, l] * m[MaxOrder - 1 - k, MaxOrder - 1 - k] - m[MaxOrder - k - 1, l] * tempEl;
                                        inv[MaxOrder - i - 2, l] = inv[MaxOrder - i - 2, l] * m[MaxOrder - 1 - k, MaxOrder - 1 - k] - inv[MaxOrder - k - 1, l] * tempEl;
                                    }
                                }
                            }
                        }
                    }
                    else
                        calcError = true;
                }
                else
                    calcError = true;
            } 
            for (k = 0; k < MaxOrder; k++)
            {
                for (i = 0; i < MaxOrder; i++)
                {
                    inv[k, i] = inv[k, i] / m[k, k];
                }
            }
            return !calcError;
        }


        public void Solve()
        {
            int k, l;
            for (k = 0; k < MaxOrder; k++)
            {
                x[k] = 0;
                for (l = 0; l < MaxOrder; l++)
                {
                    x[k] = x[k] + y[l] * inv[k, l];
                }

            }
        }


        public MainWin()
        {
            int i, k;
            DataGridViewCell cell;
            m = new double[MaxOrder, MaxOrder];
            y = new double[MaxOrder];
            x = new double[MaxOrder];
            inv = new double[MaxOrder, MaxOrder];

            InitializeComponent();
            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
            for (i = 0; i < GMatrixA.ColumnCount; i++)
                GMatrixA.Columns[i].Width = 160;
            GSolution.ColumnCount = 1;
            GSolution.RowCount = MaxOrder;
            GUnknowns.ColumnCount = MaxOrder;
            GUnknowns.RowCount = 1;

            m[0, 0] = 3.0;
            m[0, 1] = -5.0;
            m[0, 2] = 4.0;
            m[0, 3] = -3.0;

            y[0] = -2.5;

            m[1, 0] = 3.0;
            m[1, 1] = 2.0;
            m[1, 2] = 0.0;
            m[1, 3] = 4.0;

            y[1] = 14.8;

            m[2, 0] = 5.0;
            m[2, 1] = -2.0;
            m[2, 2] = 3.0;
            m[2, 3] = -3.0;

            y[2] = 4.0;

            m[3, 0] = 0.0;
            m[3, 1] = 0.0;
            m[3, 2] = -3.0;
            m[3, 3] = 2.0;

            y[3] = -4.1;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m[k, i]);
                    inv[i, k] = 0.0;
                    if (i == k)
                        inv[i, k] = 1.0;

                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(y[i]);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            double[] buf = new double[MaxOrder];
            DataGridViewCell cell;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    m[k, i] = Convert.ToDouble(cell.Value);
                }
                cell = GSolution[0, i];
                y[i] = Convert.ToDouble(cell.Value);
            }

            if (CalcInverse())
            {
                for (i = 0; i < MaxOrder; i++)
                {
                    for (k = 0; k < MaxOrder; k++)
                    {
                        cell = GMatrixA[i, k];
                        cell.Value = Convert.ToString(Math.Round(inv[i, k], 4));
                    }
                    cell = GSolution[0, i];
                    cell.Value = Convert.ToString(Math.Round(y[i], 3));
                }
                Solve();
                for (i = 0; i < MaxOrder; i++)
                {
                    cell = GUnknowns[i, 0];
                    cell.Value = Convert.ToString(Math.Round(x[i], 4));
                }
            }
            else
                MessageBox.Show("Calculation error");
        }
    }
}
