﻿using System;

namespace WindowsFormsApplication1
{
    class TFrobenius
    {
        private readonly int maxOrder;
        private double[,] m;  // main Matrix
        private double[] y;   // solution vector
        private double[,] f;  // Frobenius Matrix
        private double[,] l;  // lower diagonal Matrix

        public TFrobenius(int size, double[,] matrix, double[] solution)
        {
            maxOrder = size;
            m = matrix;
            y = solution;
            f = new double[maxOrder, maxOrder];
            l = new double[maxOrder, maxOrder];
        }

        private void MultMatrix(double[,] matrix2)
        {
            int i, j, k;
            double[,] al = new double[maxOrder, maxOrder];
            double[] yl = new double[maxOrder];
            for (i = 0; i < maxOrder; i++)
            {

                yl[i] = 0.0;
                for (j = 0; j < maxOrder; j++)
                {
                    yl[i] = yl[i] + (y[j] * matrix2[i, j]);
                    al[i, j] = 0.0;
                    for (k = 0; k < maxOrder; k++)
                    {
                        al[i, j] = al[i, j] + (matrix2[i, k] * m[k, j]);
                    }
                }
            }
            for (i = 0; i < maxOrder; i++)
            {
                y[i] = yl[i];
                for (j = 0; j < maxOrder; j++)
                {
                    m[i, j] = al[i, j];
                }
            }
        }

        private void CalcFMatrix(int i)
        {
            int j, k;
            for (j = 0; j < maxOrder; j++)
            {
                for (k = 0; k < maxOrder; k++)
                {
                    f[j, k] = 0.0;
                }
                f[j, j] = 1.0;
            }
            for (k = i + 1; k < maxOrder; k++)
            {
                f[k, i] = -m[k, i] / m[i, i];
            }
        }


        private void SwitchRows(int n)
        {
            double tempD;
            double tempL;
            int i, j;
            for (i = n; i <= maxOrder - 2; i++)
            {
                for (j = 0; j <= maxOrder - 1; j++)
                {
                    // switch rows of main matrix
                    tempD = m[i, j];
                    m[i, j] = m[i + 1, j];
                    m[i + 1, j] = tempD;
                    // switch rows of l matrix to
                    tempL = l[i, j];
                    if (j < n)
                    {
                        l[i, j] = l[i + 1, j];
                        l[i + 1, j] = tempL;
                    }
                }
                // switch elements of solution vector
                tempD = y[i];
                y[i] = y[i + 1];
                y[i + 1] = tempD;
            }
        }

        public void RunFrobenius()
        {
            int i, k;
            for (k = 0; k < maxOrder; k++)
            {
                for (i = 0; i < maxOrder - 1; i++)
                {
                    l[i, k] = 0.0;
                }
                l[k, k] = 1.0;
            }
            for (i = 0; i < maxOrder; i++)
            {
                if ((Math.Abs(m[i, i]) < 1.0E-100))
                    SwitchRows(i);
                CalcFMatrix(i);
                MultMatrix(f);
                // copy the values into the L matrix
                for (k = i + 1; k < maxOrder; k++)
                    l[k, i] = -f[k, i];
            }
        }


        public double[] Solve()
        {
            int i, j;
            double[] x = new double[maxOrder];
          
            x[maxOrder - 1] = y[maxOrder - 1] / m[maxOrder - 1, maxOrder - 1];
            for (j = maxOrder - 2; j >= 0; j--)
            {
                x[j] = y[j];
                for (i = maxOrder - 1; i > j; i--)
                {
                    x[j] = x[j] - x[i] * m[j, i];
                }
                x[j] = x[j] / m[j, j];
            }
            return x;
        }
    }
}
