﻿
using System;
using System.Windows.Forms;

/* To solve a matrix equation by LU decomposition with Frobenius matrixes  */
/*                        www.mosismath.com                                */


namespace WindowsFormsApplication1
{
    public partial class MainWin : Form
    {
        public const int MaxOrder = 4;
        public double[,] m = new double[MaxOrder, MaxOrder];  // main Matrix
        public double[] y = new double[MaxOrder];
        public double[] x = new double[MaxOrder];   // vector of the unknowns

        public MainWin()
        {
            int i, k;
            DataGridViewCell cell;
            InitializeComponent();

            GMatrixA.ColumnCount = MaxOrder;
            GMatrixA.RowCount = MaxOrder;
            for (i = 0; i < GMatrixA.ColumnCount; i++)
                GMatrixA.Columns[i].Width = 160;
            GSolution.ColumnCount = 1;
            GSolution.RowCount = MaxOrder;
            GUnknowns.ColumnCount = MaxOrder;
            GUnknowns.RowCount = 2;

            m[0, 0] = 3.0;
            m[0, 1] = -5.0;
            m[0, 2] = 4.0;
            m[0, 3] = -3.0;

            y[0] = -2.5;

            m[1, 0] = 3.0;
            m[1, 1] = 2.0;
            m[1, 2] = 0.0;
            m[1, 3] = 4.0;

            y[1] = 14.8;

            m[2, 0] = 5.0;
            m[2, 1] = -2.0;
            m[2, 2] = 3.0;
            m[2, 3] = -3.0;

            y[2] = 4.0;

            m[3, 0] = 0.0;
            m[3, 1] = 0.0;
            m[3, 2] = -3.0;
            m[3, 3] = 2.0;

            y[3] = -4.1;

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m[k, i]);
                }
                cell = GSolution[0, i];
                cell.Value = Convert.ToString(y[i]);
            }
        }

        private void button1_MouseClick(object sender, MouseEventArgs e)
        {
            int i, k;
            double[] buf = new double[MaxOrder];
            DataGridViewCell cell;            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    m[k, i] = Convert.ToDouble(cell.Value);
                }
                cell = GSolution[0, i];
                y[i] = Convert.ToDouble(cell.Value);
            }

            TFrobenius frobeniuis = new TFrobenius(MaxOrder, m, y);
            frobeniuis.RunFrobenius();

            for (i = 0; i < MaxOrder; i++)
            {
                for (k = 0; k < MaxOrder; k++)
                {
                    cell = GMatrixA[i, k];  // get cell to access
                    cell.Value = Convert.ToString(m[k, i]);

                }
            }

            x = frobeniuis.Solve();
            for (i = 0; i < MaxOrder; i++)
            {
                cell = GUnknowns[i, 0];
                cell.Value = Convert.ToString(x[i]);
            }
        }
    }

}
