﻿using System;

namespace WindowsFormsApplication1
{
    class TCrout
    {
        private readonly int maxOrder = 4;
        private double[,] m;
        private double[,] l;
        private double[,] u;
        private double[] y;

        public TCrout(int size, double[,] matrix, double[] soultion)
        {
            maxOrder = size;
            m = matrix;
            y = soultion;
            u = new double[maxOrder, maxOrder]; // upper diagonal Matrix
            l = new double[maxOrder, maxOrder]; // lower diagonal Matrix
        }

        private void SwitchRows(int n)
        {
            double tempD;
            int i, j;
            for (i = n; i <= maxOrder - 2; i++)
            {
                for (j = 0; j <= maxOrder - 1; j++)
                {
                    tempD = m[i, j];
                    m[i, j] = m[i + 1, j];
                    m[i + 1, j] = tempD;
                }
                tempD = y[i];
                y[i] = y[i + 1];
                y[i + 1] = tempD;
            }
        }

        public bool LUdecomp()
        {
            int i, j, k;
            bool result = true;
            for (i = 0; i < maxOrder; i++)
                l[i, i] = 1.0;

            for (i = 0; i < maxOrder; i++)
            {
                if (Math.Abs(m[i, i]) < 1E-10)
                    SwitchRows(i);
            }

            for (j = 0; j < maxOrder; j++)
            {
                for (i = 0; i < maxOrder; i++)
                {
                    if (i >= j)
                    {
                        u[j, i] = m[j, i];
                        for (k = 0; k < j; k++)
                            u[j, i] = u[j, i] - u[k, i] * l[j, k];
                    }
                    if (i > j)
                    {
                        if (Math.Abs(u[j, j]) > 1E-20)
                        {
                            l[i, j] = m[i, j];
                            for (k = 0; k < j; k++)
                                l[i, j] = l[i, j] - u[k, j] * l[i, k];
                            l[i, j] = l[i, j] / u[j, j];
                        }
                        else
                            result = false;
                    }
                }
            }
            return result;
        }

        public double[] Solve()
        {
            int i, j;
            double[] x = new double[maxOrder];
            for (j = 1; j < maxOrder; j++)
            {
                for (i = 0; i < j; i++)
                {
                    y[j] = y[j] - y[i] * l[j, i];
                }
            }
            x[maxOrder - 1] = y[maxOrder - 1] / u[maxOrder - 1, maxOrder - 1];
            for (j = maxOrder - 2; j >= 0; j--)
            {
                x[j] = y[j];
                for (i = maxOrder - 1; i > j; i--)
                {
                    x[j] = x[j] - x[i] * u[j, i];
                }
                x[j] = x[j] / u[j, j];
            }
            return x;
        }
    }
}
