﻿using System;


namespace WindowsFormsApplication1
{
    class ExtFloat
    {
        private int decplaces = 2100;
        public int[] value;
        public int sign;
        public int exp;

        public ExtFloat()
        {
            value = new int[decplaces];
            sign = 1;
            exp = 0;
        }

        public ExtFloat(ExtFloat a)
        {
            int i;
            value = new int[decplaces];
            for (i = 0; i < decplaces; i++)
            {
                value[i] = a.value[i];
            }
            sign = a.sign;
            exp = a.exp;
        }

        public ExtFloat(int a)
        {
            value = new int[decplaces];
            InitInt(a);
        }


        public void InitInt(int a)
        {
            int i, j;
            int tempD;
            if (a < 0)
                sign = -1;
            else
                sign = 1;
            a = Math.Abs(a);
            i = 0;
            for (j = 0; j < value.Length; j++)
                value[j] = 0;
            while (a > 0)
            {
                tempD = a % 10;
                for (j = value.Length - 2; j >= 0; j--)
                    value[j + 1] = value[j];
                value[0] = tempD;
                if (a >= 10)
                {
                    a = (a - tempD) / 10;
                    i++;
                }
                else
                    a = 0;
            }
            exp = i;
        }

        // Overloading of the operators
        public static ExtFloat operator +(ExtFloat a, ExtFloat b)
        {
            return Add(a, b);
        }

        public static ExtFloat operator -(ExtFloat a, ExtFloat b)
        {
            return Subtract(a, b);
        }

        public static ExtFloat operator *(ExtFloat a, ExtFloat b)
        {
            return Mult(a, b);
        }

        public static ExtFloat operator /(ExtFloat a, ExtFloat b)
        {
            return Divide(a, b);
        }


        public static ExtFloat StrToNumber(string str)
        {
            int i, j;
            ExtFloat result = new ExtFloat();
            string numChars = "0123456789eE-+. ";
            string tempStr;
            int exponent;

            for (i = 0; i < str.Length; i++)
            {
                if (!numChars.Contains(new string(str[i], 1)))
                    throw new ArgumentException();
            }

            int posE = str.IndexOf("E");
            if (posE < 0)
            {
                posE = str.IndexOf("e");
                if (posE < 0)
                {
                    ParseNumber(result, str);
                }
                else
                {
                    tempStr = str.Substring(posE + 1, str.Length - 1);
                    try
                    {
                        exponent = Convert.ToInt32(tempStr);
                    }
                    catch
                    {
                        exponent = 0;
                    }
                    result.exp = exponent;
                    tempStr = str.Substring(0, posE);
                    ParseNumber(result, tempStr);
                }
            }
            else
            {
                tempStr = str.Substring(posE + 1, str.Length - 1 - posE);
                try
                {
                    exponent = Convert.ToInt32(tempStr);
                }
                catch
                {
                    exponent = 0;
                }
                result.exp = exponent;
                tempStr = str.Substring(0, posE);
                ParseNumber(result, tempStr);
            }
            j = 0;
            while ((result.value[0] == 0) && (j < result.value.Length))
            {
                for (i = 0; i < result.value.Length - 1; i++)
                {
                    result.value[i] = result.value[i + 1];
                }
                j++;
                result.exp--;
            }
            return result;
        }

        public static ExtFloat IntToNumber(int value)
        {   
            return new ExtFloat(value);
        }

        public string NumberToStr()
        {
            int i;
            string str = "";
            if (sign == -1)
                str += "-";
            str += Convert.ToString(value[0]) + ".";
            for (i = 1; i < decplaces; i++)
            {
                str += Convert.ToString(value[i]);
            }
            if (exp != 0)
            {
                str += "E";
                str += Convert.ToString(exp);
            }
            return str;
        }

        public string NumberToStr(int fractionPlaces)
        {
            int i;
            ExtFloat num = new ExtFloat(Round(fractionPlaces));
            string str = "";
            if (sign == -1)
                str += "-";
            fractionPlaces += 2;
            str += Convert.ToString(num.value[0]) + ".";
            if (fractionPlaces > decplaces)
                fractionPlaces = decplaces;
            for (i = 1; i < fractionPlaces - 1; i++)
            {
                str += Convert.ToString(num.value[i]);
            }
            if (exp != 0)
            {
                str += "E";
                str += Convert.ToString(exp);
            }
            return str;
        }

        public static void ParseNumber(ExtFloat res, string str)
        {
            int i;
            int offset = 0;
            bool foundKomma = false;
            if (str[0] == '-')
            {
                res.sign = -1;
                offset = 1;
            }
            else
            {
                if (str[0] == '+')
                {
                    res.sign = 1;
                    offset = 1;
                }
            }
            for (i = 0; i < str.Length; i++)
            {
                if ((i < res.value.Length) && ((i + offset) < str.Length))
                {
                    if (str[i + offset] == '.')
                    {
                        res.exp += i - 1;
                        offset++;
                        foundKomma = true;
                    }
                    if (str[i + offset] == ' ')
                    {
                        offset++;
                    }
                    res.value[i] = Convert.ToInt32(new string(str[i + offset], 1));
                }
            }
            if (!foundKomma)
            {
                res.exp += i - 1 - offset;
            }
        }

        public ExtFloat Abs()
        {
            ExtFloat result = new ExtFloat();
            int i;
            for (i = 0; i < decplaces; i++)
            {
                result.value[i] = value[i];
            }
            result.sign = 1;
            result.exp = exp;
            return result;
        }

        public static ExtFloat Abs(ExtFloat aIn)
        {
            ExtFloat result = new ExtFloat(aIn);
            result.sign = 1;
            return result;
        }

        public ExtFloat Round(int fractionPlaces)
        {
            ExtFloat result = new ExtFloat();
            int i;
            int tempD;
            for (i = 0; i < decplaces; i++)
            {
                result.value[i] = value[i];
            }
            result.sign = 1;
            result.exp = exp;

            if (fractionPlaces <= (decplaces - 1))
            {
                if (result.value[fractionPlaces + 1] >= 5)
                    result.value[fractionPlaces]++;
            }
            for (i = fractionPlaces + 1; i > 0; i--)
            {
                if (result.value[i] >= 10)
                {
                    tempD = result.value[i] - 10;
                    result.value[i - 1] += 1;
                    result.value[i] = tempD;
                }
            }
            for (i = fractionPlaces + 1; i < decplaces; i++)
            {
                result.value[i] = 0;
            }
            return result;
        }

        public static void CopyTo(ExtFloat a, ExtFloat b)
        {
            int i;
            for (i = 0; i < a.value.Length; i++)
            {
                b.value[i] = a.value[i];
            }
            b.sign = a.sign;
            b.exp = a.exp;
        }

        public static int Cmp(ExtFloat aIn, ExtFloat bIn)
        {
            // aIn > bIn => 1  aIn == bIn => 0  aIn < bIn => -1  
            int i;
            int result = 0;
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);
            if (aL.sign > bL.sign)
                result = 1;
            else
            {
                if (aL.sign < bL.sign)
                    result = -1;
                else
                {
                    if (aL.exp > bL.exp)
                        result = 1;
                    else
                    {
                        if (bL.exp > aL.exp)
                        {
                            result = -1;
                        }
                        else
                        {
                            for (i = 0; i < aL.value.Length; i++)
                            {
                                if (result == 0)
                                {
                                    if ((aL.value[i] * aL.sign) > (bL.value[i] * bL.sign))
                                        result = 1;
                                    else
                                    {
                                        if ((aL.value[i] * aL.sign) < (bL.value[i] * bL.sign))
                                            result = -1;
                                    }
                                }
                            }
                        }
                    }
                }
            }
            return result;
        }

        private static int CmpNum(ExtFloat aIn, ExtFloat bIn)
        {
            int i;
            int result = 0;
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);

            for (i = 0; i < aL.value.Length; i++)
            {
                if (result == 0)
                {
                    if ((aL.value[i] * aL.sign) > (bL.value[i] * bL.sign))
                        result = 1;
                    else
                    {
                        if ((aL.value[i] * aL.sign) < (bL.value[i] * bL.sign))
                            result = -1;
                    }
                }
            }
            return result;
        }


        private static ExtFloat MoveExp(ExtFloat a, int number)
        {
            int i, j;
            for (i = 0; i < number; i++)
            {
                for (j = a.value.Length - 1; j > 0; j--)
                    a.value[j] = a.value[j - 1];
                a.value[0] = 0;
            }
            a.exp += number;
            return a;
        }


        private static ExtFloat BasicSubtract(ExtFloat aL, ExtFloat bL /*, bool withExp = true*/)
        {
            // Subtract a positive number from a positive number
            int i, j;
            ExtFloat result = new ExtFloat();
            int tempD;
            bool isZero = true;
            j = 0;

            result.exp = aL.exp;
            for (i = 0; i < aL.value.Length; i++)
            {
                tempD = (aL.value[i] * aL.sign) - (bL.value[i] * bL.sign);
                if (tempD >= 0)
                {
                    result.value[i] = tempD;
                    if (tempD > 0)
                        isZero = false;
                }
                else
                {
                    if (i > 0)
                    {
                        if (!isZero)
                        {
                            result.value[i] = 10 + tempD;
                            result.value[i - 1] -= 1;
                        }
                        else
                        {
                            result.value[i] = -tempD;
                            if (result.value[i] > 0)
                                isZero = false;
                            result.sign = -1;
                            aL.sign = -1;
                            bL.sign = -1;
                        }
                    }
                    else
                    {
                        result.value[i] = -tempD;
                        if (result.value[i] > 0)
                            isZero = false;
                        result.sign = -1;
                        aL.sign = -1;
                        bL.sign = -1;
                    }
                }
            }
            for (j = result.value.Length - 1; j > 0; j--)
            {
                if (result.value[j] < 0)
                {
                    tempD = result.value[j];
                    result.value[j - 1] -= 1;
                    result.value[j] = tempD + 10;
                }
            }
            return result;
        }

     
        private static ExtFloat BasicAdd(ExtFloat aL, ExtFloat bL)
        {
            // Add a positive number to a positive number
            int i, j;
            ExtFloat result = new ExtFloat();
            int tempD;

            j = 0;
            result.exp = aL.exp;
            for (i = 0; i < aL.value.Length; i++)
            {
                result.value[i] = aL.value[i] + bL.value[i];
            }
            for (j = result.value.Length - 1; j > 0; j--)
            {
                if (result.value[j] >= 10)
                {
                    tempD = result.value[j] - (result.value[j] / 10) * 10;
                    result.value[j - 1] += result.value[j] / 10;
                    result.value[j] = tempD;
                }
            }
            if (result.value[0] >= 10)
            {
                tempD = result.value[0] / 10;
                result.value[0] = result.value[0] - (result.value[0] / 10) * 10;
                for (j = result.value.Length - 1; j > 0; j--)
                {
                    result.value[j] = result.value[j - 1];
                }
                result.value[0] = tempD;
                result.exp++;
            }
            return result;
        }

        public static ExtFloat Subtract(ExtFloat aIn, ExtFloat bIn)
        {
            int i, j;
            ExtFloat result = new ExtFloat();
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);

            j = 0;
            if (aL.exp > bL.exp)
                bL = MoveExp(bL, aL.exp - bL.exp);
            else
            {
                if (bL.exp > aL.exp)
                    aL = MoveExp(aL, bL.exp - aL.exp);
            }
            result.exp = aL.exp;
            if (aL.sign > 0)
            {
                if (bL.sign > 0)
                {
                    result = BasicSubtract(aL, bL);
                }
                else
                {
                    bL.sign = 1;
                    result = BasicAdd(aL, bL);
                }
            }
            else
            {
                aL.sign = 1;
                if (bL.sign > 0)
                {
                    result = BasicAdd(aL, bL);
                    result.sign = -result.sign;
                }
                else
                {
                    bL.sign = 1;
                    result = BasicSubtract(bL, aL);
                }

            }
            // eliminate 0's on the left side of value
            j = 0;
            while ((result.value[0] == 0) && (j < result.value.Length))
            {
                for (i = 0; i < result.value.Length - 1; i++)
                {
                    result.value[i] = result.value[i + 1];
                }
                j++;
                result.exp--;
            }
            return result;
        }


        public static ExtFloat Add(ExtFloat aIn, ExtFloat bIn)
        {
            int j;
            int order = aIn.value.Length;
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);
            ExtFloat a2 = new ExtFloat();
            ExtFloat result = new ExtFloat();
            int tempD;

            j = 0;
            if (aL.exp > bL.exp)
                bL = MoveExp(bL, aL.exp - bL.exp);
            else
            {
                if (bL.exp > aL.exp)
                    aL = MoveExp(aL, bL.exp - aL.exp);
            }
            result.exp = aL.exp;
            if (aL.sign > 0)
            {
                if (bL.sign > 0)
                {
                    result = BasicAdd(aL, bL);
                }
                else
                {
                    bL.sign = 1;
                    result = BasicSubtract(aL, bL);
                }
            }
            else
            {
                aL.sign = 1;
                if (bL.sign > 0)
                {
                    result = BasicSubtract(bL, aL);
                }
                else
                {
                    bL.sign = 1;
                    result = BasicAdd(bL, aL);
                    result.sign = -result.sign;
                }

            }
            for (j = result.value.Length - 1; j >= 1; j--)
            {
                if (result.value[j] >= 10)
                {
                    tempD = result.value[j] - 10;
                    result.value[j - 1] += 1;
                    result.value[j] = tempD;
                }
            }
            if (result.value[0] >= 10)
            {
                tempD = result.value[0] / 10;
                result.value[0] = result.value[0] - tempD * 10;
                for (j = result.value.Length - 1; j >= 1; j--)
                {
                    result.value[j] = result.value[j - 1];
                }
                result.value[0] = tempD;
                result.exp++;
            }    
            return result;
        }


        public static ExtFloat Mult(ExtFloat aIn, ExtFloat bIn)
        {
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);
            ExtFloat result = new ExtFloat();
            ExtFloat a2 = new ExtFloat();

            int i, j, k;
            int tempD;

            for (k = 0; k < bL.value.Length; k++)
            {
                for (i = 0; i < a2.value.Length; i++)
                    a2.value[i] = 0;
                a2.exp = 0;
                if (bL.value[k] > 0)
                {
                    for (i = 0; i < bL.value.Length; i++)
                    {
                        if ((k + i) < bL.value.Length)
                        {
                            a2.value[k + i] = aL.value[i] * bL.value[k];
                        }
                    }
                    for (i = aL.value.Length - 1; i > 0; i--)
                    {
                        if (a2.value[i] >= 10)
                        {
                            tempD = a2.value[i] / 10;
                            a2.value[i - 1] += tempD;
                            a2.value[i] = a2.value[i] - tempD * 10;
                        }
                    }
                    if (a2.value[0] > 10)
                    {
                        for (i = aL.value.Length - 1; i > 0; i--)
                        {
                            a2.value[i] = a2.value[i - 1];
                        }
                        tempD = a2.value[0] / 10;
                        a2.value[0] = tempD;
                        a2.value[1] = a2.value[1] - tempD * 10;
                        a2.exp++;
                    }
                    result = Add(result, a2);
                }
            }
            result.exp += aL.exp + bL.exp;
            result.sign = aL.sign * bL.sign;
            // eliminate 0's on the left side of value
            j = 0;
            while ((result.value[0] == 0) && (j < result.value.Length))
            {
                for (i = 0; i < result.value.Length - 1; i++)
                {
                    result.value[i] = result.value[i + 1];
                }
                j++;
                result.exp--;
            }
            if (result.value[0] >= 10)
            {
                tempD = result.value[0] / 10;
                result.value[0] = result.value[0] - tempD * 10;
                for (j = result.value.Length - 1; j >= 1; j--)
                {
                    result.value[j] = result.value[j - 1];
                }
                result.value[0] = tempD;
                result.exp++;
            }
            return result;
        }
        

        public static ExtFloat Mult(ExtFloat aIn, int bIn)
        {
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);

            return Mult(aIn, bL);
        }
       

        public static ExtFloat Divide(ExtFloat aIn, ExtFloat bIn)
        {
            int i, j, k;
            int actPlace = 0;
            ExtFloat aL = new ExtFloat(aIn);
            ExtFloat bL = new ExtFloat(bIn);
            ExtFloat a2 = new ExtFloat();
            ExtFloat result = new ExtFloat();

            if (Cmp(bL, result) != 0)
            {
                result.sign = aL.sign * bL.sign;
                aL.sign = 1;
                bL.sign = 1;
                for (k = 0; k < aIn.value.Length; k++)
                {
                    a2.value[0] = aL.value[0];
                    j = 0;
                    for (i = 0; i < aIn.value.Length; i++)
                    {
                        a2.value[i] = aL.value[i];
                    }
                    while (CmpNum(a2, bL) >= 0)
                    {
                        a2 = BasicSubtract(a2, bL);
                        j++;
                    }
                    result.value[actPlace] = j;
                    actPlace++;
                    for (i = 0; i < aIn.value.Length - 1; i++)
                    {
                        aL.value[i] = a2.value[i + 1];
                    }
                    aL.value[i] = 0;
                    if (a2.value[0] != 0)
                        aL.value[0] += a2.value[0] * 10;
                }
                result.exp = aL.exp - bL.exp;
            }
            else
            {
                throw new DivideByZeroException();
            }
            // eliminate 0's on the left side of value
            j = 0;
            while ((result.value[0] == 0) && (j < result.value.Length))
            {
                for (i = 0; i < result.value.Length - 1; i++)
                {
                    result.value[i] = result.value[i + 1];
                }
                j++;
                result.exp--;
            }
            return result;
        }

        public static ExtFloat Root(ExtFloat radiant, int exp)
        {
            int i, j;
            ExtFloat x = new ExtFloat();
            ExtFloat tempN = new ExtFloat();
            ExtFloat one = new ExtFloat(1);
            ExtFloat zero = new ExtFloat();
            ExtFloat DELTA = new ExtFloat(StrToNumber("1"));
            DELTA.exp = - DELTA.value.Length + 5; 
            ExtFloat x_old = new ExtFloat(radiant);
            ExtFloat x_new = new ExtFloat(radiant);
            ExtFloat extExp = new ExtFloat(exp);
            bool run = true;
            int count = 0;
            if (exp > 1)
            {
                while (run && (count < 1000))
                {
                    CopyTo(x_old, x_new);
                    for (i = 1; i < exp - 1; i++)
                        x_new = x_new * x_old;
                    tempN = (radiant - (x_new * x_old)) / extExp / x_new;
                    x = x_old + tempN;
                    run = Cmp(Abs(x_old - x), DELTA) > 0;
                    CopyTo(x, x_old);
                    count++;
                }
                if (count >= 1000)
                    x = IntToNumber(0);
            }
            else
            {
                if (exp == 1)
                    x = radiant;
                else
                {
                    if (exp < 0)
                    {
                        x = Root(radiant, -exp);
                        if (ExtFloat.Cmp(x, zero) != 0)
                            x = one / x;
                    }
                    else // exp is 0
                        x = one;
                }
            }
            // eliminate 0's on the left side of value
            j = 0;
            while ((x.value[0] == 0) && (j < x.value.Length))
            {
                for (i = 0; i < x.value.Length - 1; i++)
                {
                    x.value[i] = x.value[i + 1];
                }
                j++;
                x.exp--;
            }
            return x;
        }

        public static ExtFloat Pow(ExtFloat radiant, int exp)
        {
            ExtFloat result = new ExtFloat(1);
            int i;
            for (i = 0; i < exp; i++)
                result = result * radiant;
            return result;
        }
    }
}
