﻿
using System;
using System.ComponentModel;
using System.Windows.Forms;

 /*                Compute Pi with 2000 decimal places               */
 /*                         www.mosismath.com                        */

namespace WindowsFormsApplication1
{

    public partial class MainWin : Form
    {
        ExtFloat ONE = new ExtFloat(1);
        ExtFloat TWO = new ExtFloat(2);
        ExtFloat THREE = new ExtFloat(3);
        ExtFloat FOUR = new ExtFloat(4);
        ExtFloat FIVE = new ExtFloat(5);
        ExtFloat SIX = new ExtFloat(6);
        ExtFloat DELTA = new ExtFloat(ExtFloat.StrToNumber("1E-2021"));
        ExtFloat pi = new ExtFloat();
        ExtFloat sinus;
        BackgroundWorker calcPiThread;
        BackgroundWorker calcSineThread;

        public MainWin()
        {       
            InitializeComponent();
            calcPiThread = new BackgroundWorker();
            calcPiThread.WorkerReportsProgress = true;
            calcPiThread.DoWork += worker_CalcPi;
            calcPiThread.RunWorkerCompleted += worker_PiCalculationCompleted;

            calcSineThread = new BackgroundWorker();
            calcSineThread.WorkerReportsProgress = true;
            calcSineThread.DoWork += worker_CalcSine;
            calcSineThread.RunWorkerCompleted += worker_SineCalculationCompleted;
            btCalcSine.Enabled = false;
            pBState.Maximum = 2000;
        }

        private void btCompPi_Click(object sender, EventArgs e)
        {
            btCompPi.Enabled = false;
            calcPiThread.RunWorkerAsync();
        }

        private void worker_CalcPi(object sender, DoWorkEventArgs e)
        {
            ExtFloat n = new ExtFloat(ONE);
            ExtFloat F = new ExtFloat(ONE / THREE);
            ExtFloat G = new ExtFloat(THREE);
            ExtFloat Pn = new ExtFloat(ExtFloat.StrToNumber("1.25E-1"));
            ExtFloat In;

            G = THREE * ExtFloat.Root(G, 2);
            G = G / FOUR;
            In = Pn / FIVE;
            F = F - In;
            bool run = true;
            int i = 0;
            while (run)
            {
                n = n + ONE;
                Pn = Pn * ((TWO * n) - THREE) / TWO / FOUR / n;
                In = Pn / (TWO * n + THREE);
                F = F - In;
                run = (ExtFloat.Cmp(In.Abs(), DELTA) > 0) && (i < 10000);
                pi = G + (SIX * F);
                i++;
                lbValues.Invoke((MethodInvoker)delegate {
                    lbValues.Items.Add(i.ToString() + " In " + In.NumberToStr(10));
                    if(-In.exp <= 2000)
                        pBState.Value = -In.exp;
                });  
            }
        }

        private ExtFloat Sin(ExtFloat x)
        {
            ExtFloat result = new ExtFloat();
            ExtFloat k = new ExtFloat();
            ExtFloat fact = new ExtFloat(1);
            ExtFloat step = new ExtFloat(1); 
            int i = 0;
            int j;
            int limit = 600;

            while((i < limit) && (step.exp > -2200)) 
            {
                i++;
                fact.InitInt(1);
                for (j = (2 * i - 1); j > 1; j--)
                {
                    k.InitInt(j);
                    fact = fact * k;
                }
                step = ExtFloat.Pow(x, 2 * i - 1) / fact;
                if (i % 2 == 0)
                    result = result - step;
                else
                    result = result + step;
                pBState.Invoke((MethodInvoker)delegate {
                    lbValues.Items.Add(i.ToString() + " step " + step.NumberToStr(10));
                    pBState.Value = 2000 * i / limit;
                });
            }
            return result;
        }

        void worker_PiCalculationCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            tbResult.Text = pi.NumberToStr(2000);
            btCompPi.Enabled = true;
            btCalcSine.Enabled = true;
        }

        void worker_CalcSine(object sender, DoWorkEventArgs e)
        {
            ExtFloat tempFloat = pi / FOUR;
            tempFloat = Sin(pi / FOUR);
            sinus = tempFloat * tempFloat;
        }

        void worker_SineCalculationCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            tbSinus.Text = sinus.NumberToStr(2000);
            btCalcSine.Enabled = true;
        }

        private void btCalcSine_Click(object sender, EventArgs e)
        {
            lbValues.Items.Clear();
            btCalcSine.Enabled = false;
            calcSineThread.RunWorkerAsync();
        }
    }
}
